/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.GlobPatternUtil;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.DocTransformers;
import org.apache.solr.response.transform.RenameFieldTransformer;
import org.apache.solr.response.transform.ScoreAugmenter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.response.transform.ValueSourceAugmenter;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrDocumentFetcher;
import org.apache.solr.search.StrParser;
import org.apache.solr.search.SyntaxError;

public class SolrReturnFields
extends ReturnFields {
    public static final String SCORE = "score";
    private final List<String> globs = new ArrayList<String>(1);
    private final Set<String> fields = new HashSet<String>();
    private Set<String> okFieldNames = new HashSet<String>();
    private Set<String> reqFieldNames = null;
    protected DocTransformer transformer;
    protected boolean _wantsScore = false;
    protected boolean _wantsAllFields = false;
    protected Map<String, String> renameFields = Collections.emptyMap();
    private FIELD_SOURCES fieldSources = FIELD_SOURCES.NOT_SET;
    private SolrDocumentFetcher.RetrieveFieldsOptimizer fetchOptimizer = null;
    private static final String SOURCE_FIELD_ARGNAME = "sourceField";
    private static final TransformerFactory.FieldRenamer RENAME_FIELD_TRANSFORMER_FACTORY = new TransformerFactory.FieldRenamer(){

        @Override
        public DocTransformer create(String to, SolrParams params, SolrQueryRequest req, Map<String, String> renamedFields, Set<String> reqFieldNames) {
            boolean copy;
            String from = params.get(SolrReturnFields.SOURCE_FIELD_ARGNAME);
            from = renamedFields.getOrDefault(from, from);
            boolean bl = copy = reqFieldNames != null && reqFieldNames.contains(from);
            if (!copy) {
                renamedFields.put(from, to);
            }
            return new RenameFieldTransformer(from, to, copy);
        }

        @Override
        public boolean mayModifyValue() {
            return false;
        }
    };

    public FIELD_SOURCES getFieldSources() {
        return this.fieldSources;
    }

    public void setFieldSources(FIELD_SOURCES fieldSources) {
        this.fieldSources = fieldSources;
    }

    public SolrReturnFields() {
        this._wantsAllFields = true;
    }

    public SolrReturnFields(SolrQueryRequest req) {
        this(req.getParams().getParams("fl"), req);
    }

    public SolrReturnFields(String fl, SolrQueryRequest req) {
        if (fl == null) {
            this.parseFieldList(null, req);
        } else if (fl.trim().length() == 0) {
            this._wantsScore = true;
            this._wantsAllFields = true;
            this.transformer = new ScoreAugmenter(SCORE);
        } else {
            this.parseFieldList(new String[]{fl}, req);
        }
    }

    public SolrReturnFields(String[] fl, SolrQueryRequest req) {
        this.parseFieldList(fl, req);
    }

    public SolrReturnFields(Collection<String> plainFields, DocTransformer docTransformer) {
        if (plainFields != null) {
            this._wantsAllFields = false;
            for (String field : plainFields) {
                assert (field.indexOf(42) == -1 && !field.equals(SCORE));
                this.addField(field, null, null, false);
            }
        } else {
            this._wantsAllFields = true;
        }
        if (docTransformer != null) {
            this.transformer = docTransformer;
            String[] extraRequestFields = docTransformer.getExtraRequestFields();
            if (extraRequestFields != null) {
                Collections.addAll(this.fields, extraRequestFields);
            }
        }
    }

    public SolrDocumentFetcher.RetrieveFieldsOptimizer getFetchOptimizer(Supplier<SolrDocumentFetcher.RetrieveFieldsOptimizer> supplier) {
        if (this.fetchOptimizer == null) {
            this.fetchOptimizer = supplier.get();
        }
        return this.fetchOptimizer;
    }

    private void parseFieldList(String[] fl, SolrQueryRequest req) {
        this._wantsScore = false;
        this._wantsAllFields = false;
        if (fl == null || fl.length == 0 || fl.length == 1 && fl[0].length() == 0) {
            this._wantsAllFields = true;
            return;
        }
        ArrayDeque<DeferredRenameEntry> deferredRenameAugmenters = new ArrayDeque<DeferredRenameEntry>();
        DocTransformers augmenters = new DocTransformers();
        for (String fieldList : fl) {
            this.add(fieldList, deferredRenameAugmenters, augmenters, req);
        }
        HashMap<String, String> renamedNotCopied = new HashMap<String, String>();
        for (DeferredRenameEntry e : deferredRenameAugmenters) {
            String[] extraRequestFields;
            DocTransformer t = e.create(renamedNotCopied, this.reqFieldNames);
            augmenters.addTransformer(t);
            if (this._wantsAllFields || (extraRequestFields = t.getExtraRequestFields()) == null) continue;
            for (String f : extraRequestFields) {
                this.fields.add(f);
            }
        }
        if (!renamedNotCopied.isEmpty()) {
            this.renameFields = renamedNotCopied;
        }
        if (!this._wantsAllFields && !this.globs.isEmpty()) {
            this.fields.clear();
        }
        if (augmenters.size() == 1) {
            this.transformer = augmenters.getTransformer(0);
        } else if (augmenters.size() > 1) {
            this.transformer = augmenters;
        }
    }

    @Override
    public Map<String, String> getFieldRenames() {
        return this.renameFields;
    }

    public static String getFieldName(StrParser sp) {
        char ch;
        sp.eatws();
        int id_start = sp.pos;
        if (sp.pos < sp.end && (ch = sp.val.charAt(sp.pos)) != '$' && Character.isJavaIdentifierStart(ch)) {
            ++sp.pos;
            while (sp.pos < sp.end && (Character.isJavaIdentifierPart(ch = sp.val.charAt(sp.pos)) || ch == '.' || ch == '-')) {
                ++sp.pos;
            }
            return sp.val.substring(id_start, sp.pos);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void add(String fl, Deque<DeferredRenameEntry> deferred, DocTransformers augmenters, SolrQueryRequest req) {
        if (fl == null) {
            return;
        }
        try {
            StrParser sp = new StrParser(fl);
            while (true) {
                String funcStr;
                sp.opt(',');
                sp.eatws();
                if (sp.pos >= sp.end) {
                    return;
                }
                int start = sp.pos;
                String key = null;
                String field = SolrReturnFields.getFieldName(sp);
                char ch = sp.ch();
                if (field != null) {
                    if (sp.opt(':')) {
                        key = field;
                        field = null;
                        sp.eatws();
                        start = sp.pos;
                    } else {
                        if (Character.isWhitespace(ch) || ch == ',' || ch == '\u0000') {
                            this.addField(field, key, augmenters, false);
                            continue;
                        }
                        sp.pos = start;
                        field = null;
                    }
                }
                if (key != null) {
                    field = sp.getId(null);
                    ch = sp.ch();
                    if (field != null && (Character.isWhitespace(ch) || ch == ',' || ch == '\u0000')) {
                        deferred.addFirst(new DeferredRenameEntry(key, (SolrParams)new ModifiableSolrParams().set(SOURCE_FIELD_ARGNAME, new String[]{field}), req, RENAME_FIELD_TRANSFORMER_FACTORY));
                        this.addField(field, key, augmenters, true);
                        continue;
                    }
                    sp.pos = start;
                    field = null;
                }
                if (field == null) {
                    field = sp.getGlobbedId(null);
                    ch = sp.ch();
                    if (field != null && (Character.isWhitespace(ch) || ch == ',' || ch == '\u0000')) {
                        if ("*".equals(field)) {
                            this._wantsAllFields = true;
                            continue;
                        }
                        this.globs.add(field);
                        continue;
                    }
                    sp.pos = start;
                }
                if ((funcStr = sp.val.substring(start)).startsWith("[")) {
                    DocTransformer t;
                    TransformerFactory factory;
                    ModifiableSolrParams augmenterParams = new ModifiableSolrParams();
                    int end = QueryParsing.parseLocalParams(funcStr, 0, augmenterParams, req.getParams(), "[", ']');
                    sp.pos += end;
                    String string = augmenterParams.get("type");
                    augmenterParams.remove("type");
                    Object disp = key;
                    if (disp == null) {
                        disp = "[" + string + "]";
                    }
                    if ((factory = req.getCore().getTransformerFactory(string)) instanceof TransformerFactory.FieldRenamer) {
                        DeferredRenameEntry deferredEntry = new DeferredRenameEntry((String)disp, (SolrParams)augmenterParams, req, (TransformerFactory.FieldRenamer)((Object)factory));
                        if (((TransformerFactory.FieldRenamer)((Object)factory)).mayModifyValue()) {
                            deferred.addLast(deferredEntry);
                        } else {
                            deferred.addFirst(deferredEntry);
                        }
                    } else if (factory != null && (t = factory.create((String)disp, (SolrParams)augmenterParams, req)) != null) {
                        String[] extra;
                        if (!this._wantsAllFields && (extra = t.getExtraRequestFields()) != null) {
                            for (String f : extra) {
                                this.fields.add(f);
                            }
                        }
                        augmenters.addTransformer(t);
                    }
                    this.addField(field, (String)disp, augmenters, true);
                    continue;
                }
                QParser parser = QParser.getParser(funcStr, "func", req);
                Query q = null;
                Object var13_17 = null;
                try {
                    void var13_20;
                    SolrParams localParams;
                    block35: {
                        block36: {
                            if (!(parser instanceof FunctionQParser)) break block36;
                            FunctionQParser fparser = (FunctionQParser)parser;
                            fparser.setParseMultipleSources(false);
                            fparser.setParseToEnd(false);
                            q = fparser.getQuery();
                            if (fparser.localParams != null) {
                                if (fparser.valFollowedParams) {
                                    int leftOver = fparser.sp.end - fparser.sp.pos;
                                    sp.pos = sp.end - leftOver;
                                    break block35;
                                } else {
                                    sp.pos = start + fparser.localParamsEnd;
                                }
                                break block35;
                            } else {
                                int leftOver = fparser.sp.end - fparser.sp.pos;
                                sp.pos = sp.end - leftOver;
                            }
                            break block35;
                        }
                        q = parser.getQuery();
                        assert (parser.getLocalParams() != null);
                        sp.pos = start + parser.localParamsEnd;
                    }
                    funcStr = sp.val.substring(start, sp.pos);
                    if (q instanceof FunctionQuery) {
                        ValueSource valueSource = ((FunctionQuery)q).getValueSource();
                    } else {
                        QueryValueSource queryValueSource = new QueryValueSource(q, 0.0f);
                    }
                    if (key == null && (localParams = parser.getLocalParams()) != null) {
                        key = localParams.get("key");
                    }
                    if (key == null) {
                        key = funcStr;
                    }
                    this.addField(funcStr, key, augmenters, true);
                    augmenters.addTransformer(new ValueSourceAugmenter(key, parser, (ValueSource)var13_20));
                }
                catch (SyntaxError e) {
                    sp.pos = start;
                    field = sp.getSimpleString();
                    if (req.getSchema().getFieldOrNull(field) == null) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing fieldname: " + e.getMessage(), (Throwable)e);
                    this.addField(field, key, augmenters, false);
                    if (key == null) continue;
                    deferred.addFirst(new DeferredRenameEntry(key, (SolrParams)new ModifiableSolrParams().set(SOURCE_FIELD_ARGNAME, new String[]{field}), req, RENAME_FIELD_TRANSFORMER_FACTORY));
                }
            }
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing fieldname", (Throwable)e);
        }
    }

    private void addField(String field, String key, DocTransformers augmenters, boolean isPseudoField) {
        if (this.reqFieldNames == null) {
            this.reqFieldNames = new LinkedHashSet<String>();
        }
        if (key == null) {
            this.reqFieldNames.add(field);
        } else {
            this.reqFieldNames.add(key);
        }
        if (!isPseudoField) {
            this.fields.add(field);
        }
        this.okFieldNames.add(field);
        this.okFieldNames.add(key);
        if (SCORE.equals(field)) {
            this._wantsScore = true;
            String disp = key == null ? field : key;
            augmenters.addTransformer(new ScoreAugmenter(disp));
        }
    }

    @Override
    public Set<String> getLuceneFieldNames() {
        return this.getLuceneFieldNames(false);
    }

    @Override
    public Set<String> getLuceneFieldNames(boolean ignoreWantsAll) {
        if (ignoreWantsAll) {
            return this.fields;
        }
        return this._wantsAllFields || this.fields.isEmpty() ? null : this.fields;
    }

    @Override
    public Set<String> getRequestedFieldNames() {
        if (this._wantsAllFields || this.reqFieldNames == null || this.reqFieldNames.isEmpty()) {
            return null;
        }
        return this.reqFieldNames;
    }

    @Override
    public Set<String> getExplicitlyRequestedFieldNames() {
        if (this.reqFieldNames == null || this.reqFieldNames.isEmpty()) {
            return null;
        }
        return this.reqFieldNames;
    }

    @Override
    public boolean hasPatternMatching() {
        return !this.globs.isEmpty();
    }

    @Override
    public boolean wantsField(String name) {
        if (this._wantsAllFields || this.okFieldNames.contains(name)) {
            return true;
        }
        for (String s : this.globs) {
            if (!GlobPatternUtil.matches((String)s, (String)name)) continue;
            this.okFieldNames.add(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean wantsAllFields() {
        return this._wantsAllFields;
    }

    @Override
    public boolean wantsScore() {
        return this._wantsScore;
    }

    @Override
    public DocTransformer getTransformer() {
        return this.transformer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SolrReturnFields=(");
        sb.append("globs=");
        sb.append(this.globs);
        sb.append(",fields=");
        sb.append(this.fields);
        sb.append(",okFieldNames=");
        sb.append(this.okFieldNames);
        sb.append(",reqFieldNames=");
        sb.append(this.reqFieldNames);
        sb.append(",transformer=");
        sb.append(this.transformer);
        sb.append(",wantsScore=");
        sb.append(this._wantsScore);
        sb.append(",wantsAllFields=");
        sb.append(this._wantsAllFields);
        sb.append(')');
        return sb.toString();
    }

    private static final class DeferredRenameEntry {
        private final String field;
        private final SolrParams params;
        private final SolrQueryRequest req;
        private final TransformerFactory.FieldRenamer factory;

        private DeferredRenameEntry(String field, SolrParams params, SolrQueryRequest req, TransformerFactory.FieldRenamer factory) {
            this.field = field;
            this.params = params;
            this.req = req;
            this.factory = factory;
        }

        private DocTransformer create(Map<String, String> renamedFields, Set<String> reqFieldNames) {
            return this.factory.create(this.field, this.params, this.req, renamedFields, reqFieldNames);
        }
    }

    public static enum FIELD_SOURCES {
        NOT_SET,
        ALL_FROM_DV,
        ALL_FROM_STORED,
        MIXED_SOURCES;

    }
}

