/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.servlet.ServletUtils;

public final class LoadAdminUiServlet
extends HttpServlet {
    private static final boolean disabled = Boolean.parseBoolean(System.getProperty("disableAdminUI", "false"));
    public static final String SYSPROP_CSP_CONNECT_SRC_URLS = "solr.ui.headers.csp.connect-src.urls";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block13: {
            if (disabled) {
                response.sendError(404, "Solr Admin UI is disabled. To enable it, change the default value of SOLR_ADMIN_UI_ENABLED in bin/solr.in.sh or solr.in.cmd.");
                return;
            }
            request = ServletUtils.closeShield(request);
            response = ServletUtils.closeShield(response);
            response.addHeader("X-Frame-Options", "DENY");
            String admin = request.getRequestURI().substring(request.getContextPath().length());
            CoreContainer cores = (CoreContainer)request.getAttribute("org.apache.solr.CoreContainer");
            try (InputStream in = this.getServletContext().getResourceAsStream(admin);){
                if (in != null && cores != null) {
                    response.setCharacterEncoding("UTF-8");
                    response.setContentType("text/html");
                    String connectSrc = this.generateCspConnectSrc();
                    response.setHeader("Content-Security-Policy", "default-src 'none'; base-uri 'none'; connect-src " + connectSrc + "; form-action 'self'; font-src 'self'; frame-ancestors 'none'; img-src 'self' data:; media-src 'self'; style-src 'self' 'unsafe-inline'; script-src 'self'; worker-src 'self';");
                    try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)CloseShieldOutputStream.wrap((OutputStream)response.getOutputStream()), StandardCharsets.UTF_8);){
                        String html = new String(in.readAllBytes(), StandardCharsets.UTF_8).replace("${version}", this.getSolrCorePackageSpecVersion());
                        out.write(html);
                        break block13;
                    }
                }
                response.sendError(404);
            }
        }
    }

    private String getSolrCorePackageSpecVersion() {
        Package pack = SolrCore.class.getPackage();
        return pack.getSpecificationVersion() != null ? pack.getSpecificationVersion() : "Unknown";
    }

    private String generateCspConnectSrc() {
        String cspURLs = System.getProperty(SYSPROP_CSP_CONNECT_SRC_URLS, "");
        ArrayList<String> props = new ArrayList<String>(Arrays.asList(cspURLs.split(",")));
        props.add("'self'");
        return String.join((CharSequence)" ", props);
    }
}

