/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import javax.naming.Context;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DefaultSettingsContext;
import org.openide.util.Lookup;

public final class Environment {
    private static Lookup.Result<Provider> result;

    private Environment() {
    }

    public static Lookup find(DataObject dataObject) {
        while (dataObject != null) {
            Lookup lookup = Environment.findForOne(dataObject);
            if (lookup != null) {
                return lookup;
            }
            FileObject fileObject = dataObject.getPrimaryFile().getParent();
            if (fileObject == null) break;
            try {
                dataObject = DataObject.find(fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                break;
            }
        }
        return Lookup.EMPTY;
    }

    @Deprecated
    public static Context findSettingsContext(DataObject dataObject) {
        for (Provider provider : Environment.getProviders().allInstances()) {
            Context context;
            Lookup lookup = provider.getEnvironment(dataObject);
            if (lookup == null || (context = (Context)lookup.lookup(Context.class)) == null) continue;
            return context;
        }
        return new DefaultSettingsContext(dataObject);
    }

    static Lookup findForOne(DataObject dataObject) {
        for (Provider provider : Environment.getProviders().allInstances()) {
            Lookup lookup = provider.getEnvironment(dataObject);
            if (lookup == null) continue;
            return lookup;
        }
        return null;
    }

    static Lookup.Result<Provider> getProviders() {
        if (result == null) {
            result = Lookup.getDefault().lookupResult(Provider.class);
        }
        return result;
    }

    public static interface Provider {
        public Lookup getEnvironment(DataObject var1);
    }
}

