/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailvalidator;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mailvalidator.MailValidator;
import org.pentaho.di.trans.steps.mailvalidator.MailValidatorData;
import org.pentaho.di.trans.steps.mailvalidator.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailValidatorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String emailfield;
    private boolean ResultAsString;
    private boolean smtpCheck;
    private String emailValideMsg;
    private String emailNotValideMsg;
    private String errorsFieldName;
    private String timeout;
    private String defaultSMTP;
    private String emailSender;
    private String defaultSMTPField;
    private boolean isdynamicDefaultSMTP;
    private String resultfieldname;

    public String getEmailField() {
        return this.emailfield;
    }

    public void setEmailfield(String emailfield) {
        this.emailfield = emailfield;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public void setEmailValideMsg(String emailValideMsg) {
        this.emailValideMsg = emailValideMsg;
    }

    public String getEMailValideMsg() {
        return this.emailValideMsg;
    }

    public String getEMailNotValideMsg() {
        return this.emailNotValideMsg;
    }

    public String getErrorsField() {
        return this.errorsFieldName;
    }

    public void setErrorsField(String errorsFieldName) {
        this.errorsFieldName = errorsFieldName;
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    public String getDefaultSMTP() {
        return this.defaultSMTP;
    }

    public void setDefaultSMTP(String defaultSMTP) {
        this.defaultSMTP = defaultSMTP;
    }

    public String geteMailSender() {
        return this.emailSender;
    }

    public void seteMailSender(String emailSender) {
        this.emailSender = emailSender;
    }

    public String getDefaultSMTPField() {
        return this.defaultSMTPField;
    }

    public void setDefaultSMTPField(String defaultSMTPField) {
        this.defaultSMTPField = defaultSMTPField;
    }

    public boolean isdynamicDefaultSMTP() {
        return this.isdynamicDefaultSMTP;
    }

    public void setdynamicDefaultSMTP(boolean isdynamicDefaultSMTP) {
        this.isdynamicDefaultSMTP = isdynamicDefaultSMTP;
    }

    public void setEmailNotValideMsg(String emailNotValideMsg) {
        this.emailNotValideMsg = emailNotValideMsg;
    }

    public boolean isResultAsString() {
        return this.ResultAsString;
    }

    public void setResultAsString(boolean ResultAsString) {
        this.ResultAsString = ResultAsString;
    }

    public void setSMTPCheck(boolean smtpcheck) {
        this.smtpCheck = smtpcheck;
    }

    public boolean isSMTPCheck() {
        return this.smtpCheck;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        MailValidatorMeta retval = (MailValidatorMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.resultfieldname = "result";
        this.emailValideMsg = "email address is valid";
        this.emailNotValideMsg = "email address is not valid";
        this.ResultAsString = false;
        this.errorsFieldName = "Error message";
        this.timeout = "0";
        this.defaultSMTP = null;
        this.emailSender = "noreply@domain.com";
        this.smtpCheck = false;
        this.isdynamicDefaultSMTP = false;
        this.defaultSMTPField = null;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v;
        String realResultFieldName = space.environmentSubstitute(this.resultfieldname);
        if (this.ResultAsString) {
            v = new ValueMeta(realResultFieldName, 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        } else {
            v = new ValueMeta(realResultFieldName, 4);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        String realErrorsFieldName = space.environmentSubstitute(this.errorsFieldName);
        if (!Const.isEmpty((String)realErrorsFieldName)) {
            ValueMeta v2 = new ValueMeta(realErrorsFieldName, 2);
            v2.setLength(100, -1);
            v2.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v2);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"emailfield", (String)this.emailfield));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    ").append(XMLHandler.addTagValue((String)"ResultAsString", (boolean)this.ResultAsString));
        retval.append("    ").append(XMLHandler.addTagValue((String)"smtpCheck", (boolean)this.smtpCheck));
        retval.append("    " + XMLHandler.addTagValue((String)"emailValideMsg", (String)this.emailValideMsg));
        retval.append("    " + XMLHandler.addTagValue((String)"emailNotValideMsg", (String)this.emailNotValideMsg));
        retval.append("    " + XMLHandler.addTagValue((String)"errorsFieldName", (String)this.errorsFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("    " + XMLHandler.addTagValue((String)"defaultSMTP", (String)this.defaultSMTP));
        retval.append("    " + XMLHandler.addTagValue((String)"emailSender", (String)this.emailSender));
        retval.append("    " + XMLHandler.addTagValue((String)"defaultSMTPField", (String)this.defaultSMTPField));
        retval.append("    " + XMLHandler.addTagValue((String)"isdynamicDefaultSMTP", (boolean)this.isdynamicDefaultSMTP));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.emailfield = XMLHandler.getTagValue((Node)stepnode, (String)"emailfield");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.ResultAsString = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ResultAsString"));
            this.smtpCheck = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"smtpCheck"));
            this.emailValideMsg = XMLHandler.getTagValue((Node)stepnode, (String)"emailValideMsg");
            this.emailNotValideMsg = XMLHandler.getTagValue((Node)stepnode, (String)"emailNotValideMsg");
            this.errorsFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"errorsFieldName");
            this.timeout = XMLHandler.getTagValue((Node)stepnode, (String)"timeout");
            this.defaultSMTP = XMLHandler.getTagValue((Node)stepnode, (String)"defaultSMTP");
            this.emailSender = XMLHandler.getTagValue((Node)stepnode, (String)"emailSender");
            this.defaultSMTPField = XMLHandler.getTagValue((Node)stepnode, (String)"defaultSMTPField");
            this.isdynamicDefaultSMTP = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"isdynamicDefaultSMTP"));
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("MailValidatorMeta.Exception.UnableToReadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.emailfield = rep.getStepAttributeString(id_step, "emailfield");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
            this.ResultAsString = rep.getStepAttributeBoolean(id_step, "ResultAsString");
            this.smtpCheck = rep.getStepAttributeBoolean(id_step, "smtpCheck");
            this.emailValideMsg = rep.getStepAttributeString(id_step, "emailValideMsg");
            this.emailNotValideMsg = rep.getStepAttributeString(id_step, "emailNotValideMsg");
            this.errorsFieldName = rep.getStepAttributeString(id_step, "errorsFieldName");
            this.timeout = rep.getStepAttributeString(id_step, "timeout");
            this.defaultSMTP = rep.getStepAttributeString(id_step, "defaultSMTP");
            this.emailSender = rep.getStepAttributeString(id_step, "emailSender");
            this.defaultSMTPField = rep.getStepAttributeString(id_step, "defaultSMTPField");
            this.isdynamicDefaultSMTP = rep.getStepAttributeBoolean(id_step, "isdynamicDefaultSMTP");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("MailValidatorMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "emailfield", this.emailfield);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "ResultAsString", this.ResultAsString);
            rep.saveStepAttribute(id_transformation, id_step, "smtpCheck", this.smtpCheck);
            rep.saveStepAttribute(id_transformation, id_step, "emailValideMsg", this.emailValideMsg);
            rep.saveStepAttribute(id_transformation, id_step, "emailNotValideMsg", this.emailNotValideMsg);
            rep.saveStepAttribute(id_transformation, id_step, "errorsFieldName", this.errorsFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "timeout", this.timeout);
            rep.saveStepAttribute(id_transformation, id_step, "defaultSMTP", this.defaultSMTP);
            rep.saveStepAttribute(id_transformation, id_step, "emailSender", this.emailSender);
            rep.saveStepAttribute(id_transformation, id_step, "defaultSMTPField", this.defaultSMTPField);
            rep.saveStepAttribute(id_transformation, id_step, "isdynamicDefaultSMTP", this.isdynamicDefaultSMTP);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("MailValidatorMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr = Const.isEmpty((String)this.resultfieldname) ? new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.ResultFieldMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.ResultFieldOk"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (this.ResultAsString) {
            cr = Const.isEmpty((String)this.emailValideMsg) ? new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.EmailValidMsgMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.EmailValidMsgOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            cr = Const.isEmpty((String)this.emailNotValideMsg) ? new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.EmailNotValidMsgMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.EmailNotValidMsgOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = Const.isEmpty((String)this.emailfield) ? new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.eMailFieldMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.eMailFieldOK"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.ReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.NoInpuReceived"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (this.ResultAsString) {
            cr = Const.isEmpty((String)this.emailValideMsg) ? new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.eMailValidMsgMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.eMailValidMsgOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            cr = Const.isEmpty((String)this.emailNotValideMsg) ? new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.eMailNotValidMsgMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.eMailNotValidMsgOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.smtpCheck) {
            cr = Const.isEmpty((String)this.emailSender) ? new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.eMailSenderMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.eMailSenderOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            if (this.isdynamicDefaultSMTP) {
                cr = Const.isEmpty((String)this.defaultSMTPField) ? new CheckResult(4, Messages.getString("MailValidatorMeta.CheckResult.dynamicDefaultSMTPFieldMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("MailValidatorMeta.CheckResult.dynamicDefaultSMTPFieldOk"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new MailValidator(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MailValidatorData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

