/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.images;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.resources.ImageCache;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.util.ImageUtils;

public final class BaseTileTransitionImageCreator {
    private final ImageLibrary lib;
    private final ImageCache imageCache;

    public BaseTileTransitionImageCreator(ImageLibrary lib, ImageCache imageCache) {
        this.lib = lib;
        this.imageCache = imageCache;
    }

    public BufferedImage getBaseTileTransitionImage(Tile tile, Direction direction, boolean useNiceCorners, boolean useVariations) {
        String transitionKey;
        int maskVariationNumber;
        boolean beachTransitionSw;
        boolean beachTransitionNe;
        boolean renderSpecialTransition;
        Tile borderingTile = tile.getNeighbourOrNull(direction);
        boolean bl = renderSpecialTransition = useNiceCorners && (direction == Direction.NW || direction == Direction.SE);
        if (borderingTile == null || !borderingTile.isExplored() || !tile.isExplored()) {
            return null;
        }
        if (tile.getType() == borderingTile.getType() && !renderSpecialTransition) {
            return null;
        }
        ImageResource terrainImageResource = this.getTerrainOrBeachImageResource(tile, borderingTile);
        if (terrainImageResource == null) {
            return null;
        }
        ImageResource tileImageResource = ImageCache.getImageResource(ImageLibrary.getTerrainImageKey(tile.getType()));
        if (tileImageResource == null) {
            return null;
        }
        if (terrainImageResource.getCachingKey().equals(tileImageResource.getCachingKey()) && !renderSpecialTransition) {
            return null;
        }
        if (renderSpecialTransition) {
            beachTransitionNe = this.shouldIncludeSpecialBeachTransitionInDirection(tile, borderingTile, Direction.NE);
            beachTransitionSw = this.shouldIncludeSpecialBeachTransitionInDirection(tile, borderingTile, Direction.SW);
        } else {
            beachTransitionNe = false;
            beachTransitionSw = false;
        }
        ImageResource terrainMaskResource = this.lib.getTerrainMaskResource(direction);
        if (useVariations && terrainMaskResource.getNumberOfVariations() > 1) {
            Tile transitionSeedTile = direction == Direction.NW || direction == Direction.NE ? tile : borderingTile;
            int seed = ImageLibrary.variationSeedUsing(transitionSeedTile.getX(), transitionSeedTile.getY());
            maskVariationNumber = new Random(seed).nextInt(terrainMaskResource.getNumberOfVariations() - 1);
        } else {
            maskVariationNumber = terrainMaskResource.getNumberOfVariations() - 1;
        }
        if (renderSpecialTransition) {
            Tile neBorderingTile = borderingTile.getNeighbourOrNull(Direction.NE);
            Tile swBorderingTile = borderingTile.getNeighbourOrNull(Direction.SW);
            transitionKey = terrainImageResource.getCachingKey() + "," + (neBorderingTile != null && neBorderingTile.getType() != null ? neBorderingTile.getType().getId() : "null") + "," + (swBorderingTile != null && swBorderingTile.getType() != null ? swBorderingTile.getType().getId() : "null") + "," + maskVariationNumber + "," + beachTransitionNe + beachTransitionSw + "$baseTransition$gen";
        } else {
            transitionKey = terrainImageResource.getCachingKey() + "," + maskVariationNumber + "$baseTransition$gen";
        }
        BufferedImage transitionImage = this.imageCache.getCachedImageOrGenerate(transitionKey, this.lib.getTileSize(), false, direction.ordinal(), () -> {
            BufferedImage transitionTileImage;
            BufferedImage terrainImage = this.imageCache.getCachedImage(terrainImageResource, this.lib.getTileSize(), false, 0);
            if (!renderSpecialTransition) {
                transitionTileImage = terrainImage;
            } else {
                BufferedImage transitionImage3;
                transitionTileImage = ImageUtils.createBufferedImage(terrainImage.getWidth(), terrainImage.getHeight());
                Graphics2D tranitionG2d = transitionTileImage.createGraphics();
                if (tile.isLand() || borderingTile.isLand()) {
                    tranitionG2d.drawImage((Image)terrainImage, 0, 0, null);
                } else {
                    if (beachTransitionNe) {
                        tranitionG2d.drawImage((Image)this.getSpecialBeachBaseTileTransitionImage(Direction.NE), 0, 0, null);
                    }
                    if (beachTransitionSw) {
                        tranitionG2d.drawImage((Image)this.getSpecialBeachBaseTileTransitionImage(Direction.SW), 0, 0, null);
                    }
                }
                BufferedImage transitionImage2 = this.getBaseTileTransitionImage(borderingTile, Direction.NE, false, false);
                if (transitionImage2 != null) {
                    tranitionG2d.drawImage((Image)transitionImage2, 0, 0, null);
                }
                if ((transitionImage3 = this.getBaseTileTransitionImage(borderingTile, Direction.SW, false, false)) != null) {
                    tranitionG2d.drawImage((Image)transitionImage3, 0, 0, null);
                }
                tranitionG2d.dispose();
            }
            BufferedImage terrainMaskImage = this.imageCache.getCachedImage(terrainMaskResource, this.lib.getTileSize(), false, maskVariationNumber);
            return ImageUtils.imageWithAlphaFromMask(transitionTileImage, terrainMaskImage);
        });
        return transitionImage;
    }

    private boolean shouldIncludeSpecialBeachTransitionInDirection(Tile tile, Tile borderingTile, Direction direction) {
        if (tile.isLand() || borderingTile.isLand()) {
            return false;
        }
        Tile tileNeighbour = tile.getNeighbourOrNull(direction);
        Tile borderingTileNeighbour = borderingTile.getNeighbourOrNull(direction);
        return tileNeighbour != null && tileNeighbour.isLand() || borderingTileNeighbour != null && borderingTileNeighbour.isLand();
    }

    private BufferedImage getSpecialBeachBaseTileTransitionImage(Direction direction) {
        String transitionKey = "specialBeachTransition." + direction.toString() + "$gen";
        BufferedImage resultImage = this.imageCache.getCachedImageOrGenerate(transitionKey, this.lib.getTileSize(), false, direction.ordinal(), () -> {
            BufferedImage beachImage = this.imageCache.getCachedImage(ImageLibrary.getBeachCenterImageResource(), this.lib.getTileSize(), false, 0);
            return ImageUtils.imageWithAlphaFromMask(beachImage, this.getSpecialBeachBaseTileTransitionMask(direction));
        });
        return resultImage;
    }

    private BufferedImage getSpecialBeachBaseTileTransitionMask(Direction direction) {
        String key = "image.mask.special.beach." + direction.toString().toLowerCase();
        return this.imageCache.getSizedImage(key, this.lib.getTileSize(), false);
    }

    private ImageResource getTerrainOrBeachImageResource(Tile tile, Tile borderingTile) {
        if (borderingTile == null) {
            return null;
        }
        boolean notABeachTransition = borderingTile.isLand() || !borderingTile.isLand() && !tile.isLand();
        ImageResource terrainImageResource = notABeachTransition ? ImageCache.getImageResource(ImageLibrary.getTerrainImageKey(borderingTile.getType())) : ImageLibrary.getBeachCenterImageResource();
        return terrainImageResource;
    }
}

