/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class ChangeWorkImprovementTypeMessage
extends AttributeMessage {
    public static final String TAG = "changeWorkImprovementType";
    private static final String IMPROVEMENT_TYPE_TAG = "improvementType";
    private static final String UNIT_TAG = "unit";

    public ChangeWorkImprovementTypeMessage(Unit unit, TileImprovementType type) {
        super(TAG, UNIT_TAG, unit.getId(), IMPROVEMENT_TYPE_TAG, type.getId());
    }

    public ChangeWorkImprovementTypeMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, IMPROVEMENT_TYPE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String improvementId = this.getStringAttribute(IMPROVEMENT_TYPE_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return serverPlayer.clientError("Unit is not on the map: " + unitId);
        }
        if (!unit.hasAbility("model.ability.improveTerrain")) {
            return serverPlayer.clientError("Unit can not improve tiles: " + unitId);
        }
        TileImprovementType type = freeColServer.getSpecification().getTileImprovementType(improvementId);
        if (type == null) {
            return serverPlayer.clientError("Not a tile improvement type: " + improvementId);
        }
        if (type.isNatural()) {
            return serverPlayer.clientError("ImprovementType must not be natural: " + improvementId);
        }
        if (!type.isTileTypeAllowed(tile.getType())) {
            return serverPlayer.clientError("ImprovementType not allowed on tile: " + improvementId);
        }
        TileImprovement improvement = tile.getTileImprovement(type);
        if (improvement == null) {
            if (!type.isWorkerAllowed(unit)) {
                return serverPlayer.clientError("Unit can not create improvement: " + improvementId);
            }
        } else if (!improvement.isWorkerAllowed(unit)) {
            return serverPlayer.clientError("Unit can not work on improvement: " + improvementId);
        }
        return this.igc(freeColServer).changeWorkImprovementType(serverPlayer, unit, type);
    }
}

