/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.kademlia;

import java.util.Collections;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.SimpleDataStructure;
import net.i2p.kademlia.KBucket;
import net.i2p.kademlia.KBucketTrimmer;
import net.i2p.kademlia.SelectionCollector;
import net.i2p.util.ConcurrentHashSet;

class KBucketImpl<T extends SimpleDataStructure>
implements KBucket<T> {
    private final Set<T> _entries;
    private final int _begin;
    private final int _end;
    private final int _max;
    private final KBucketTrimmer<T> _trimmer;
    private long _lastChanged;
    private final I2PAppContext _context;

    public KBucketImpl(I2PAppContext context, int begin, int end, int max, KBucketTrimmer<T> trimmer) {
        if (begin > end) {
            throw new IllegalArgumentException(begin + " > " + end);
        }
        this._context = context;
        this._entries = new ConcurrentHashSet<T>(max + 4);
        this._begin = begin;
        this._end = end;
        this._max = max;
        this._trimmer = trimmer;
    }

    @Override
    public int getRangeBegin() {
        return this._begin;
    }

    @Override
    public int getRangeEnd() {
        return this._end;
    }

    @Override
    public int getKeyCount() {
        return this._entries.size();
    }

    @Override
    public Set<T> getEntries() {
        return Collections.unmodifiableSet(this._entries);
    }

    @Override
    public void getEntries(SelectionCollector<T> collector) {
        for (SimpleDataStructure h : this._entries) {
            collector.add(h);
        }
    }

    @Override
    public void clear() {
        this._entries.clear();
    }

    @Override
    public boolean add(T peer) {
        if (this._begin != this._end || this._entries.size() < this._max || this._entries.contains(peer) || this._trimmer.trim(this, peer)) {
            boolean rv = this._entries.add(peer);
            this.setLastChanged();
            return rv;
        }
        return false;
    }

    @Override
    public boolean remove(T peer) {
        boolean rv = this._entries.remove(peer);
        return rv;
    }

    @Override
    public void setLastChanged() {
        this._lastChanged = this._context.clock().now();
    }

    @Override
    public long getLastChanged() {
        return this._lastChanged;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(this._entries.size());
        buf.append(" entries in (").append(this._begin);
        if (this._end != this._begin) {
            buf.append('-').append(this._end);
        }
        buf.append(") : ").append(this._entries.toString());
        return buf.toString();
    }
}

