/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.AttributeMapper;
import io.github.dmlloyd.classfile.ClassFileElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AttributedElement
extends ClassFileElement {
    public List<Attribute<?>> attributes();

    default public <T extends Attribute<T>> Optional<T> findAttribute(AttributeMapper<T> attr) {
        Objects.requireNonNull(attr);
        for (Attribute<?> la : this.attributes()) {
            if (la.attributeMapper() != attr) continue;
            Optional<Attribute<?>> res = Optional.of(la);
            return res;
        }
        return Optional.empty();
    }

    default public <T extends Attribute<T>> List<T> findAttributes(AttributeMapper<T> attr) {
        Objects.requireNonNull(attr);
        ArrayList list = new ArrayList();
        for (Attribute<?> a : this.attributes()) {
            if (a.attributeMapper() != attr) continue;
            Attribute<?> t = a;
            list.add(t);
        }
        return Collections.unmodifiableList(list);
    }
}

