/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.util.logging.Logger;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.layoutprocessor.AbstractReportElementLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.layoutprocessor.TableCellLayoutController;
import org.libreoffice.report.pentaho.model.FormattedTextElement;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormattedTextLayoutController
extends AbstractReportElementLayoutController {
    private static final Logger LOGGER = Logger.getLogger(FormattedTextLayoutController.class.getName());

    @Override
    public boolean isValueChanged() {
        try {
            FormattedTextElement formattedTextElement = (FormattedTextElement)this.getNode();
            FormulaExpression formulaExpression = formattedTextElement.getValueExpression();
            if (formulaExpression.getFormulaExpression() == null) {
                return false;
            }
            Formula formula = formulaExpression.getCompiledFormula();
            LValue lValue = formula.getRootReference();
            return FormatValueUtility.isReferenceChanged(this, lValue);
        }
        catch (ParseException parseException) {
            LOGGER.config("Parse Exception: " + (Object)((Object)parseException));
            return false;
        }
    }

    @Override
    protected LayoutController delegateContentGeneration(ReportTarget reportTarget) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        FormattedTextElement formattedTextElement = (FormattedTextElement)this.getNode();
        DataFlags dataFlags = FormatValueUtility.computeDataFlag(formattedTextElement, this.getFlowController());
        if (dataFlags != null) {
            if (dataFlags.getValue() instanceof String) {
                reportTarget.processContent(dataFlags);
            } else {
                Element element = this.getParentTableCell();
                if (element != null && "string".equals(element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type"))) {
                    reportTarget.processContent(dataFlags);
                }
            }
        }
        return this.join(this.getFlowController());
    }

    private Element getParentTableCell() {
        for (LayoutController layoutController = this.getParent(); layoutController != null; layoutController = layoutController.getParent()) {
            if (!(layoutController instanceof TableCellLayoutController)) continue;
            TableCellLayoutController tableCellLayoutController = (TableCellLayoutController)layoutController;
            return tableCellLayoutController.getElement();
        }
        return null;
    }
}

