/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.internal;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.serial.ProtocolType;
import org.openhab.core.io.transport.serial.SerialPortProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SerialPortRegistry.class})
@NonNullByDefault
public class SerialPortRegistry {
    private final Collection<SerialPortProvider> portCreators = new HashSet<SerialPortProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void registerSerialPortCreator(SerialPortProvider creator) {
        Collection<SerialPortProvider> collection = this.portCreators;
        synchronized (collection) {
            this.portCreators.add(creator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSerialPortCreator(SerialPortProvider creator) {
        Collection<SerialPortProvider> collection = this.portCreators;
        synchronized (collection) {
            this.portCreators.remove(creator);
        }
    }

    public Collection<SerialPortProvider> getPortProvidersForPortName(URI portName) {
        String scheme = portName.getScheme();
        ProtocolType.PathType pathType = ProtocolType.PathType.fromURI(portName);
        Predicate<SerialPortProvider> filter = scheme != null ? provider -> provider.getAcceptedProtocols().anyMatch(prot -> prot.getScheme().equals(scheme)) : provider -> provider.getAcceptedProtocols().anyMatch(prot -> prot.getPathType().equals((Object)pathType));
        return this.portCreators.stream().filter(filter).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SerialPortProvider> getPortCreators() {
        Collection<SerialPortProvider> collection = this.portCreators;
        synchronized (collection) {
            return Set.copyOf(this.portCreators);
        }
    }
}

