/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.types;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.StateDescriptionFragment;
import org.openhab.core.types.StateOption;

@NonNullByDefault
public class StateDescriptionFragmentImpl
implements StateDescriptionFragment {
    private @Nullable BigDecimal minimum;
    private @Nullable BigDecimal maximum;
    private @Nullable BigDecimal step;
    private @Nullable String pattern;
    private @Nullable Boolean readOnly;
    private @Nullable List<StateOption> options;

    public StateDescriptionFragmentImpl() {
    }

    @Deprecated
    public StateDescriptionFragmentImpl(@Nullable BigDecimal minimum, @Nullable BigDecimal maximum, @Nullable BigDecimal step, @Nullable String pattern, @Nullable Boolean readOnly, @Nullable List<StateOption> options) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.step = step;
        this.pattern = pattern;
        this.readOnly = readOnly;
        this.options = options == null || options.isEmpty() ? List.of() : Collections.unmodifiableList(options);
    }

    @Deprecated
    public StateDescriptionFragmentImpl(StateDescription legacy) {
        this.minimum = legacy.getMinimum();
        this.maximum = legacy.getMaximum();
        this.step = legacy.getStep();
        this.pattern = legacy.getPattern();
        this.readOnly = legacy.isReadOnly();
        if (!legacy.getOptions().isEmpty()) {
            this.options = legacy.getOptions();
        }
    }

    public StateDescriptionFragmentImpl(StateDescriptionFragmentImpl source) {
        this.minimum = source.getMinimum();
        this.maximum = source.getMaximum();
        this.step = source.getStep();
        this.pattern = source.getPattern();
        this.readOnly = source.isReadOnly();
        this.options = source.getOptions();
    }

    @Override
    public @Nullable BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
    }

    @Override
    public @Nullable BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
    }

    @Override
    public @Nullable BigDecimal getStep() {
        return this.step;
    }

    public void setStep(BigDecimal step) {
        this.step = step;
    }

    @Override
    public @Nullable String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public @Nullable Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public @Nullable List<StateOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<StateOption> options) {
        this.options = options;
    }

    @Override
    public @Nullable StateDescription toStateDescription() {
        if (this.minimum == null && this.maximum == null && this.step == null && this.readOnly == null && this.pattern == null && this.options == null) {
            return null;
        }
        Boolean ro = this.readOnly;
        return new StateDescriptionImpl(this.minimum, this.maximum, this.step, this.pattern, ro != null && ro != false, this.options);
    }

    public StateDescriptionFragment merge(StateDescriptionFragment fragment) {
        List<StateOption> localOptions;
        if (this.minimum == null) {
            this.minimum = fragment.getMinimum();
        }
        if (this.maximum == null) {
            this.maximum = fragment.getMaximum();
        }
        if (this.step == null) {
            this.step = fragment.getStep();
        }
        if (this.pattern == null) {
            this.pattern = fragment.getPattern();
        }
        if (this.readOnly == null) {
            this.readOnly = fragment.isReadOnly();
        }
        if ((localOptions = this.options) == null || localOptions.isEmpty()) {
            this.options = fragment.getOptions();
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.minimum);
        result = 31 * result + Objects.hashCode(this.maximum);
        result = 31 * result + Objects.hashCode(this.step);
        result = 31 * result + Objects.hashCode(this.pattern);
        result = 31 * result + (this.readOnly != false ? 1231 : 1237);
        result = 31 * result + Objects.hashCode(this.options);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateDescriptionFragmentImpl other = (StateDescriptionFragmentImpl)obj;
        return Objects.equals(this.minimum, other.minimum) && Objects.equals(this.maximum, other.maximum) && Objects.equals(this.step, other.step) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.readOnly, other.readOnly) && Objects.equals(this.options, other.options);
    }

    public String toString() {
        return "StateDescription [minimum=" + String.valueOf(this.minimum) + ", maximum=" + String.valueOf(this.maximum) + ", step=" + String.valueOf(this.step) + ", pattern=" + this.pattern + ", readOnly=" + String.valueOf(this.readOnly) + ", channelStateOptions=" + String.valueOf(this.options) + "]";
    }

    private static class StateDescriptionImpl
    extends StateDescription {
        StateDescriptionImpl(@Nullable BigDecimal minimum, @Nullable BigDecimal maximum, @Nullable BigDecimal step, @Nullable String pattern, boolean readOnly, @Nullable List<StateOption> options) {
            super(minimum, maximum, step, pattern, readOnly, options);
        }
    }
}

