/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.rulesupport.shared;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.module.script.rulesupport.internal.ScriptedCustomModuleHandlerFactory;
import org.openhab.core.automation.module.script.rulesupport.internal.ScriptedCustomModuleTypeProvider;
import org.openhab.core.automation.module.script.rulesupport.internal.ScriptedPrivateModuleHandlerFactory;
import org.openhab.core.automation.module.script.rulesupport.shared.RuleSupportRuleRegistryDelegate;
import org.openhab.core.automation.module.script.rulesupport.shared.ScriptedHandler;
import org.openhab.core.automation.module.script.rulesupport.shared.simple.SimpleActionHandler;
import org.openhab.core.automation.module.script.rulesupport.shared.simple.SimpleConditionHandler;
import org.openhab.core.automation.module.script.rulesupport.shared.simple.SimpleRuleActionHandler;
import org.openhab.core.automation.module.script.rulesupport.shared.simple.SimpleRuleActionHandlerDelegate;
import org.openhab.core.automation.module.script.rulesupport.shared.simple.SimpleTriggerHandler;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.TriggerType;
import org.openhab.core.automation.util.ActionBuilder;
import org.openhab.core.automation.util.ConditionBuilder;
import org.openhab.core.automation.util.ModuleBuilder;
import org.openhab.core.automation.util.RuleBuilder;
import org.openhab.core.automation.util.TriggerBuilder;
import org.openhab.core.config.core.Configuration;

@NonNullByDefault
public class ScriptedAutomationManager {
    private final RuleSupportRuleRegistryDelegate ruleRegistryDelegate;
    private final Set<String> modules = new HashSet<String>();
    private final Set<String> moduleHandlers = new HashSet<String>();
    private final Set<String> privateHandlers = new HashSet<String>();
    private final ScriptedCustomModuleHandlerFactory scriptedCustomModuleHandlerFactory;
    private final ScriptedCustomModuleTypeProvider scriptedCustomModuleTypeProvider;
    private final ScriptedPrivateModuleHandlerFactory scriptedPrivateModuleHandlerFactory;

    public ScriptedAutomationManager(RuleSupportRuleRegistryDelegate ruleRegistryDelegate, ScriptedCustomModuleHandlerFactory scriptedCustomModuleHandlerFactory, ScriptedCustomModuleTypeProvider scriptedCustomModuleTypeProvider, ScriptedPrivateModuleHandlerFactory scriptedPrivateModuleHandlerFactory) {
        this.ruleRegistryDelegate = ruleRegistryDelegate;
        this.scriptedCustomModuleHandlerFactory = scriptedCustomModuleHandlerFactory;
        this.scriptedCustomModuleTypeProvider = scriptedCustomModuleTypeProvider;
        this.scriptedPrivateModuleHandlerFactory = scriptedPrivateModuleHandlerFactory;
    }

    public void removeModuleType(String uid) {
        if (this.modules.remove(uid)) {
            this.scriptedCustomModuleTypeProvider.removeModuleType(uid);
            this.removeHandler(uid);
        }
    }

    public void removeHandler(String typeUID) {
        if (this.moduleHandlers.remove(typeUID)) {
            this.scriptedCustomModuleHandlerFactory.removeModuleHandler(typeUID);
        }
    }

    public void removePrivateHandler(String privId) {
        if (this.privateHandlers.remove(privId)) {
            this.scriptedPrivateModuleHandlerFactory.removeHandler(privId);
        }
    }

    public void removeAll() {
        HashSet<String> types = new HashSet<String>(this.modules);
        for (String moduleType : types) {
            this.removeModuleType(moduleType);
        }
        HashSet<String> moduleHandlers = new HashSet<String>(this.moduleHandlers);
        for (String uid : moduleHandlers) {
            this.removeHandler(uid);
        }
        HashSet<String> privateHandlers = new HashSet<String>(this.privateHandlers);
        for (String privId : privateHandlers) {
            this.removePrivateHandler(privId);
        }
        this.ruleRegistryDelegate.removeAllAddedByScript();
    }

    public Rule addRule(Rule element) {
        Rule rule = this.addUnmanagedRule(element);
        this.ruleRegistryDelegate.add(rule);
        return rule;
    }

    public Rule addUnmanagedRule(Rule element) {
        Condition toAdd;
        RuleBuilder builder = RuleBuilder.create((String)element.getUID());
        String name = element.getName();
        if ((name == null || name.isEmpty()) && (name = element.getClass().getSimpleName()).contains("$")) {
            name = name.substring(0, name.indexOf(36));
        }
        builder.withName(name).withDescription(element.getDescription()).withTags(element.getTags());
        int moduleIndex = 1;
        try {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            Iterator iterator = element.getConditions().iterator();
            while (iterator.hasNext()) {
                Condition cond;
                toAdd = cond = (Condition)iterator.next();
                if (cond.getId().isEmpty()) {
                    toAdd = ((ConditionBuilder)((ConditionBuilder)((ConditionBuilder)ModuleBuilder.createCondition().withId(Integer.toString(moduleIndex++))).withTypeUID(cond.getTypeUID())).withConfiguration(cond.getConfiguration())).withInputs(cond.getInputs()).build();
                }
                conditions.add(toAdd);
            }
            builder.withConditions(conditions);
        }
        catch (Exception conditions) {
            // empty catch block
        }
        try {
            ArrayList<Condition> triggers = new ArrayList<Condition>();
            for (Trigger trigger : element.getTriggers()) {
                toAdd = trigger;
                if (trigger.getId().isEmpty()) {
                    toAdd = ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)ModuleBuilder.createTrigger().withId(Integer.toString(moduleIndex++))).withTypeUID(trigger.getTypeUID())).withConfiguration(trigger.getConfiguration())).build();
                }
                triggers.add(toAdd);
            }
            builder.withTriggers(triggers);
        }
        catch (Exception triggers) {
            // empty catch block
        }
        ArrayList<Action> actions = new ArrayList<Action>(element.getActions());
        if (element instanceof SimpleRuleActionHandler) {
            SimpleRuleActionHandler handler = (SimpleRuleActionHandler)element;
            String privId = this.addPrivateActionHandler(new SimpleRuleActionHandlerDelegate(handler));
            Action scriptedAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)ActionBuilder.create().withId(Integer.toString(moduleIndex++))).withTypeUID("jsr223.ScriptedAction")).withConfiguration(new Configuration())).build();
            scriptedAction.getConfiguration().put("privId", (Object)privId);
            actions.add(scriptedAction);
        }
        builder.withConfiguration(element.getConfiguration());
        builder.withActions(actions);
        return builder.build();
    }

    public void addConditionType(ConditionType conditionType) {
        this.modules.add(conditionType.getUID());
        this.scriptedCustomModuleTypeProvider.addModuleType((ModuleType)conditionType);
    }

    public void addConditionHandler(String uid, ScriptedHandler conditionHandler) {
        this.moduleHandlers.add(uid);
        this.scriptedCustomModuleHandlerFactory.addModuleHandler(uid, conditionHandler);
        this.scriptedCustomModuleTypeProvider.updateModuleHandler(uid);
    }

    public String addPrivateConditionHandler(SimpleConditionHandler conditionHandler) {
        String uid = this.scriptedPrivateModuleHandlerFactory.addHandler(conditionHandler);
        this.privateHandlers.add(uid);
        return uid;
    }

    public void addActionType(ActionType actionType) {
        this.modules.add(actionType.getUID());
        this.scriptedCustomModuleTypeProvider.addModuleType((ModuleType)actionType);
    }

    public void addActionHandler(String uid, ScriptedHandler actionHandler) {
        this.moduleHandlers.add(uid);
        this.scriptedCustomModuleHandlerFactory.addModuleHandler(uid, actionHandler);
        this.scriptedCustomModuleTypeProvider.updateModuleHandler(uid);
    }

    public String addPrivateActionHandler(SimpleActionHandler actionHandler) {
        String uid = this.scriptedPrivateModuleHandlerFactory.addHandler(actionHandler);
        this.privateHandlers.add(uid);
        return uid;
    }

    public void addTriggerType(TriggerType triggerType) {
        this.modules.add(triggerType.getUID());
        this.scriptedCustomModuleTypeProvider.addModuleType((ModuleType)triggerType);
    }

    public void addTriggerHandler(String uid, ScriptedHandler triggerHandler) {
        this.moduleHandlers.add(uid);
        this.scriptedCustomModuleHandlerFactory.addModuleHandler(uid, triggerHandler);
        this.scriptedCustomModuleTypeProvider.updateModuleHandler(uid);
    }

    public String addPrivateTriggerHandler(SimpleTriggerHandler triggerHandler) {
        String uid = this.scriptedPrivateModuleHandlerFactory.addHandler(triggerHandler);
        this.privateHandlers.add(uid);
        return uid;
    }
}

