/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Format;
import java.util.regex.Pattern;

public class PatternFormat
implements Format {
    private final String name;
    private final Pattern pattern;
    private final String messageKey;
    private final String errorMessageDescription;

    @Deprecated
    public PatternFormat(String name, String regex, String errorMessageDescription) {
        this.name = name;
        this.errorMessageDescription = errorMessageDescription != null ? errorMessageDescription : regex;
        this.messageKey = "format";
        this.pattern = Pattern.compile(regex);
    }

    private PatternFormat(String name, String regex, String errorMessageDescription, String messageKey) {
        this.name = name;
        this.errorMessageDescription = errorMessageDescription != null ? errorMessageDescription : regex;
        this.messageKey = messageKey;
        this.pattern = Pattern.compile(regex);
    }

    public static PatternFormat of(String name, String regex, String messageKey) {
        return new PatternFormat(name, regex, null, messageKey != null ? messageKey : "format");
    }

    @Override
    public boolean matches(ExecutionContext executionContext, String value) {
        return this.pattern.matcher(value).matches();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public String getErrorMessageDescription() {
        return this.errorMessageDescription;
    }
}

