/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.executor;

import com.amazon.randomcutforest.ComponentList;
import com.amazon.randomcutforest.executor.AbstractForestUpdateExecutor;
import com.amazon.randomcutforest.executor.IStateCoordinator;
import com.amazon.randomcutforest.executor.UpdateResult;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;

public class ParallelForestUpdateExecutor<PointReference, Point>
extends AbstractForestUpdateExecutor<PointReference, Point> {
    private ForkJoinPool forkJoinPool;
    private final int threadPoolSize;

    public ParallelForestUpdateExecutor(IStateCoordinator<PointReference, Point> updateCoordinator, ComponentList<PointReference, Point> components, int threadPoolSize) {
        super(updateCoordinator, components);
        this.threadPoolSize = threadPoolSize;
        this.forkJoinPool = new ForkJoinPool(threadPoolSize);
    }

    @Override
    protected List<UpdateResult<PointReference>> update(PointReference point, long seqNum) {
        return this.submitAndJoin(() -> this.components.parallelStream().map(t -> t.update(point, seqNum)).filter(UpdateResult::isStateChange).collect(Collectors.toList()));
    }

    private <T> T submitAndJoin(Callable<T> callable) {
        if (this.forkJoinPool == null) {
            this.forkJoinPool = new ForkJoinPool(this.threadPoolSize);
        }
        return (T)((ForkJoinTask)this.forkJoinPool.submit((Callable)callable)).join();
    }
}

