/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;

@Processor(value=MLProcessorType.SET_FIELD)
public class MLSetFieldProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLSetFieldProcessor.class);
    private final String targetPath;
    private final Object value;
    private final String sourcePath;
    private final Object defaultValue;
    private final boolean hasDefault;

    public MLSetFieldProcessor(Map<String, Object> config) {
        super(config);
        this.targetPath = (String)config.get("path");
        this.value = config.get("value");
        this.sourcePath = (String)config.get("source_path");
        this.defaultValue = config.get("default");
        this.hasDefault = config.containsKey("default");
    }

    @Override
    protected void validateConfig() {
        String sourcePathValue;
        if (!this.config.containsKey("path")) {
            throw new IllegalArgumentException("'path' is required for set_field processor");
        }
        String pathValue = (String)this.config.get("path");
        if (pathValue == null || pathValue.trim().isEmpty()) {
            throw new IllegalArgumentException("'path' cannot be empty for set_field processor");
        }
        boolean hasValue = this.config.containsKey("value");
        boolean hasSourcePath = this.config.containsKey("source_path");
        if (!hasValue && !hasSourcePath) {
            throw new IllegalArgumentException("Either 'value' or 'source_path' is required for set_field processor");
        }
        if (hasValue && hasSourcePath) {
            throw new IllegalArgumentException("Cannot specify both 'value' and 'source_path' for set_field processor");
        }
        if (hasSourcePath && ((sourcePathValue = (String)this.config.get("source_path")) == null || sourcePathValue.trim().isEmpty())) {
            throw new IllegalArgumentException("'source_path' cannot be empty for set_field processor");
        }
        if (this.config.containsKey("default") && !hasSourcePath) {
            throw new IllegalArgumentException("'default' can only be used with 'source_path' for set_field processor");
        }
    }

    @Override
    public Object process(Object input) {
        try {
            String jsonStr = StringUtils.toJson((Object)input);
            DocumentContext context = JsonPath.parse((String)jsonStr);
            Object valueToSet = this.determineValue(context);
            if (valueToSet == null && this.sourcePath != null && !this.hasDefault) {
                return input;
            }
            if (!this.setValueAtPath(context, valueToSet)) {
                return input;
            }
            return context.json();
        }
        catch (Exception e) {
            log.warn("Failed to set field at path '{}': {}", (Object)this.targetPath, (Object)e.getMessage());
            return input;
        }
    }

    private Object determineValue(DocumentContext context) {
        if (this.sourcePath != null) {
            try {
                Object sourceValue = context.read(this.sourcePath, new Predicate[0]);
                log.debug("Read value from source path '{}'", (Object)this.sourcePath);
                return sourceValue;
            }
            catch (Exception e) {
                if (this.hasDefault) {
                    log.debug("Failed to read from source path '{}', using default value", (Object)this.sourcePath);
                    return this.defaultValue;
                }
                log.warn("Failed to read from source path '{}' and no default provided: {}", (Object)this.sourcePath, (Object)e.getMessage());
                return null;
            }
        }
        return this.value;
    }

    private boolean setValueAtPath(DocumentContext context, Object valueToSet) {
        try {
            context.set(this.targetPath, valueToSet, new Predicate[0]);
            log.debug("Successfully set value at path '{}'", (Object)this.targetPath);
            return true;
        }
        catch (Exception setException) {
            log.debug("Path '{}' doesn't exist, attempting to create it", (Object)this.targetPath);
            return this.createAndSetPath(context, valueToSet, setException);
        }
    }

    private boolean createAndSetPath(DocumentContext context, Object valueToSet, Exception originalException) {
        int lastBracketIndex;
        int lastDotIndex = this.targetPath.lastIndexOf(46);
        if (lastDotIndex > (lastBracketIndex = this.targetPath.lastIndexOf(91))) {
            String parentPath = this.targetPath.substring(0, lastDotIndex);
            String key = this.targetPath.substring(lastDotIndex + 1);
            try {
                context.put(parentPath, key, valueToSet, new Predicate[0]);
                log.debug("Successfully created new field '{}' at parent path '{}'", (Object)key, (Object)parentPath);
                return true;
            }
            catch (Exception putException) {
                log.warn("Failed to create new path '{}': parent path '{}' may not exist or is not an object. Error: {}", (Object)this.targetPath, (Object)parentPath, (Object)putException.getMessage());
                return false;
            }
        }
        log.warn("Failed to set path '{}' and cannot create it (array paths not supported for creation): {}", (Object)this.targetPath, (Object)originalException.getMessage());
        return false;
    }
}

