/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.commons.alerting.model.CronSchedule;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.DetectorInput;
import org.opensearch.securityanalytics.model.DetectorTrigger;

public class Detector
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(Detector.class);
    private static final String DETECTOR_TYPE = "detector";
    private static final String TYPE_FIELD = "type";
    public static final String DETECTOR_TYPE_FIELD = "detector_type";
    private static final String LOG_TYPE_FIELD = "log_type";
    public static final String NAME_FIELD = "name";
    private static final String USER_FIELD = "user";
    public static final String ENABLED_FIELD = "enabled";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String NO_ID = "";
    public static final Long NO_VERSION = 1L;
    public static final String INPUTS_FIELD = "inputs";
    public static final String TRIGGERS_FIELD = "triggers";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    public static final String THREAT_INTEL_ENABLED_FIELD = "threat_intel_enabled";
    public static final String ALERTING_MONITOR_ID = "monitor_id";
    public static final String ALERTING_WORKFLOW_ID = "workflow_ids";
    public static final String BUCKET_MONITOR_ID_RULE_ID = "bucket_monitor_id_rule_id";
    private static final String RULE_TOPIC_INDEX = "rule_topic_index";
    private static final String ALERTS_INDEX = "alert_index";
    private static final String ALERTS_HISTORY_INDEX = "alert_history_index";
    private static final String ALERTS_HISTORY_INDEX_PATTERN = "alert_history_index_pattern";
    private static final String FINDINGS_INDEX = "findings_index";
    private static final String FINDINGS_INDEX_PATTERN = "findings_index_pattern";
    public static final String DETECTORS_INDEX = ".opensearch-sap-detectors-config";
    public static final String DOC_LEVEL_MONITOR = "-1";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Detector.class, new ParseField("detector", new String[0]), xcp -> Detector.parse(xcp, null, null));
    private String id;
    private Long version;
    private String name;
    private Boolean threatIntelEnabled;
    private Boolean enabled;
    private Schedule schedule;
    private Instant lastUpdateTime;
    private Instant enabledTime;
    private String logType;
    private User user;
    private List<DetectorInput> inputs;
    private List<DetectorTrigger> triggers;
    private List<String> monitorIds;
    private Map<String, String> ruleIdMonitorIdMap;
    private List<String> workflowIds;
    private String ruleIndex;
    private String alertsIndex;
    private String alertsHistoryIndex;
    private String alertsHistoryIndexPattern;
    private String findingsIndex;
    private String findingsIndexPattern;
    private final String type;

    public Detector(String id, Long version, String name, Boolean enabled, Schedule schedule, Instant lastUpdateTime, Instant enabledTime, String logType, User user, List<DetectorInput> inputs, List<DetectorTrigger> triggers, List<String> monitorIds, String ruleIndex, String alertsIndex, String alertsHistoryIndex, String alertsHistoryIndexPattern, String findingsIndex, String findingsIndexPattern, Map<String, String> rulePerMonitor, List<String> workflowIds, Boolean threatIntelEnabled) {
        this.type = DETECTOR_TYPE;
        this.id = id != null ? id : NO_ID;
        this.version = version != null ? version : NO_VERSION;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.lastUpdateTime = lastUpdateTime;
        this.enabledTime = enabledTime;
        this.user = user;
        this.inputs = inputs;
        this.triggers = triggers;
        this.monitorIds = monitorIds != null ? monitorIds : Collections.emptyList();
        this.ruleIndex = ruleIndex;
        this.alertsIndex = alertsIndex;
        this.alertsHistoryIndex = alertsHistoryIndex;
        this.alertsHistoryIndexPattern = alertsHistoryIndexPattern;
        this.findingsIndex = findingsIndex;
        this.findingsIndexPattern = findingsIndexPattern;
        this.ruleIdMonitorIdMap = rulePerMonitor;
        this.logType = logType;
        this.workflowIds = workflowIds != null ? workflowIds : null;
        this.threatIntelEnabled = threatIntelEnabled != null && threatIntelEnabled != false;
        if (enabled.booleanValue()) {
            Objects.requireNonNull(enabledTime);
        }
    }

    public Detector(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), sin.readString(), sin.readBoolean(), Schedule.readFrom((StreamInput)sin), sin.readInstant(), sin.readOptionalInstant(), sin.readString(), sin.readBoolean() ? new User(sin) : null, sin.readList(DetectorInput::readFrom), sin.readList(DetectorTrigger::readFrom), sin.readStringList(), sin.readOptionalString(), sin.readOptionalString(), sin.readOptionalString(), sin.readOptionalString(), sin.readOptionalString(), sin.readOptionalString(), sin.readMap(StreamInput::readString, StreamInput::readString), sin.readStringList(), sin.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeString(this.name);
        out.writeBoolean(this.enabled.booleanValue());
        if (this.schedule instanceof CronSchedule) {
            out.writeEnum((Enum)Schedule.TYPE.CRON);
        } else {
            out.writeEnum((Enum)Schedule.TYPE.INTERVAL);
        }
        this.schedule.writeTo(out);
        out.writeInstant(this.lastUpdateTime);
        out.writeOptionalInstant(this.enabledTime);
        out.writeString(this.logType);
        out.writeBoolean(this.user != null);
        if (this.user != null) {
            this.user.writeTo(out);
        }
        out.writeVInt(this.inputs.size());
        for (DetectorInput detectorInput : this.inputs) {
            detectorInput.writeTo(out);
        }
        out.writeVInt(this.triggers.size());
        for (DetectorTrigger detectorTrigger : this.triggers) {
            detectorTrigger.writeTo(out);
        }
        out.writeStringCollection(this.monitorIds);
        out.writeOptionalString(this.ruleIndex);
        out.writeOptionalString(this.alertsIndex);
        out.writeOptionalString(this.alertsHistoryIndex);
        out.writeOptionalString(this.alertsHistoryIndexPattern);
        out.writeOptionalString(this.findingsIndex);
        out.writeOptionalString(this.findingsIndexPattern);
        out.writeMap(this.ruleIdMonitorIdMap, StreamOutput::writeString, StreamOutput::writeString);
        if (this.workflowIds != null) {
            out.writeStringCollection(this.workflowIds);
        }
        out.writeBoolean(this.threatIntelEnabled.booleanValue());
    }

    public XContentBuilder toXContentWithUser(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.createXContentBuilder(builder, params, false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.createXContentBuilder(builder, params, true);
    }

    private XContentBuilder createXContentBuilder(XContentBuilder builder, ToXContent.Params params, Boolean secure) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(this.type);
        }
        builder.field(TYPE_FIELD, this.type).field(NAME_FIELD, this.name).field(DETECTOR_TYPE_FIELD, this.logType);
        if (!secure.booleanValue()) {
            if (this.user == null) {
                builder.nullField(USER_FIELD);
            } else {
                builder.field(USER_FIELD, (ToXContent)this.user);
            }
        }
        builder.field(THREAT_INTEL_ENABLED_FIELD, this.threatIntelEnabled);
        builder.field(ENABLED_FIELD, this.enabled);
        if (this.enabledTime == null) {
            builder.nullField(ENABLED_TIME_FIELD);
        } else {
            builder.timeField(ENABLED_TIME_FIELD, String.format(Locale.getDefault(), "%s_in_millis", ENABLED_TIME_FIELD), this.enabledTime.toEpochMilli());
        }
        builder.field(SCHEDULE_FIELD, (ToXContent)this.schedule);
        DetectorInput[] inputsArray = new DetectorInput[]{};
        inputsArray = this.inputs.toArray(inputsArray);
        builder.field(INPUTS_FIELD, (Object)inputsArray);
        DetectorTrigger[] triggerArray = new DetectorTrigger[]{};
        triggerArray = this.triggers.toArray(triggerArray);
        builder.field(TRIGGERS_FIELD, (Object)triggerArray);
        if (this.lastUpdateTime == null) {
            builder.nullField(LAST_UPDATE_TIME_FIELD);
        } else {
            builder.timeField(LAST_UPDATE_TIME_FIELD, String.format(Locale.getDefault(), "%s_in_millis", LAST_UPDATE_TIME_FIELD), this.lastUpdateTime.toEpochMilli());
        }
        builder.field(ALERTING_MONITOR_ID, this.monitorIds);
        if (this.workflowIds == null) {
            builder.nullField(ALERTING_WORKFLOW_ID);
        } else {
            builder.field(ALERTING_WORKFLOW_ID, this.workflowIds);
        }
        builder.field(BUCKET_MONITOR_ID_RULE_ID, this.ruleIdMonitorIdMap);
        builder.field(RULE_TOPIC_INDEX, this.ruleIndex);
        builder.field(ALERTS_INDEX, this.alertsIndex);
        builder.field(ALERTS_HISTORY_INDEX, this.alertsHistoryIndex);
        builder.field(ALERTS_HISTORY_INDEX_PATTERN, this.alertsHistoryIndexPattern);
        builder.field(FINDINGS_INDEX, this.findingsIndex);
        builder.field(FINDINGS_INDEX_PATTERN, this.findingsIndexPattern);
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public static Detector docParse(XContentParser xcp, String id, Long version) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        Detector detector = (Detector)xcp.namedObject(Detector.class, xcp.currentName(), null);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        detector.setId(id);
        detector.setVersion(version);
        return detector;
    }

    public static Detector parse(XContentParser xcp, String id, Long version) throws IOException {
        if (id == null) {
            id = NO_ID;
        }
        if (version == null) {
            version = NO_VERSION;
        }
        String name = null;
        String detectorType = null;
        String logType = null;
        User user = null;
        Schedule schedule = null;
        Instant lastUpdateTime = null;
        Instant enabledTime = null;
        Boolean enabled = true;
        ArrayList<DetectorInput> inputs = new ArrayList<DetectorInput>();
        ArrayList<DetectorTrigger> triggers = new ArrayList<DetectorTrigger>();
        ArrayList<String> monitorIds = new ArrayList<String>();
        ArrayList<String> workflowIds = new ArrayList<String>();
        HashMap<String, String> rulePerMonitor = new HashMap();
        String ruleIndex = null;
        String alertsIndex = null;
        String alertsHistoryIndex = null;
        String alertsHistoryIndexPattern = null;
        String findingsIndex = null;
        String findingsIndexPattern = null;
        Boolean enableThreatIntel = false;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block42: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    continue block42;
                }
                case "detector_type": {
                    logType = xcp.text();
                    continue block42;
                }
                case "user": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        user = null;
                        continue block42;
                    }
                    user = User.parse((XContentParser)xcp);
                    continue block42;
                }
                case "enabled": {
                    enabled = xcp.booleanValue();
                    continue block42;
                }
                case "threat_intel_enabled": {
                    enableThreatIntel = xcp.booleanValue();
                    continue block42;
                }
                case "schedule": {
                    schedule = Schedule.parse((XContentParser)xcp);
                    continue block42;
                }
                case "inputs": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        DetectorInput input = DetectorInput.parse(xcp);
                        inputs.add(input);
                    }
                    continue block42;
                }
                case "triggers": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        DetectorTrigger trigger = DetectorTrigger.parse(xcp);
                        triggers.add(trigger);
                    }
                    continue block42;
                }
                case "enabled_time": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        enabledTime = null;
                        continue block42;
                    }
                    if (xcp.currentToken().isValue()) {
                        enabledTime = Instant.ofEpochMilli(xcp.longValue());
                        continue block42;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    enabledTime = null;
                    continue block42;
                }
                case "last_update_time": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        lastUpdateTime = null;
                        continue block42;
                    }
                    if (xcp.currentToken().isValue()) {
                        lastUpdateTime = Instant.ofEpochMilli(xcp.longValue());
                        continue block42;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    lastUpdateTime = null;
                    continue block42;
                }
                case "monitor_id": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String monitorId = xcp.text();
                        monitorIds.add(monitorId);
                    }
                    continue block42;
                }
                case "workflow_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String workflowId = xcp.textOrNull();
                        if (workflowId == null) continue;
                        workflowIds.add(workflowId);
                    }
                    continue block42;
                }
                case "bucket_monitor_id_rule_id": {
                    rulePerMonitor = xcp.mapStrings();
                    continue block42;
                }
                case "rule_topic_index": {
                    ruleIndex = xcp.text();
                    continue block42;
                }
                case "alert_index": {
                    alertsIndex = xcp.text();
                    continue block42;
                }
                case "alert_history_index": {
                    alertsHistoryIndex = xcp.text();
                    continue block42;
                }
                case "alert_history_index_pattern": {
                    alertsHistoryIndexPattern = xcp.text();
                    continue block42;
                }
                case "findings_index": {
                    findingsIndex = xcp.text();
                    continue block42;
                }
                case "findings_index_pattern": {
                    findingsIndexPattern = xcp.text();
                    continue block42;
                }
            }
            xcp.skipChildren();
        }
        if (enabled.booleanValue() && enabledTime == null) {
            enabledTime = Instant.now();
        } else if (!enabled.booleanValue()) {
            enabledTime = null;
        }
        if (logType == null) {
            logType = detectorType;
        }
        return new Detector(id, version, Objects.requireNonNull(name, "Detector name is null"), enabled, Objects.requireNonNull(schedule, "Detector schedule is null"), lastUpdateTime != null ? lastUpdateTime : Instant.now(), enabledTime, logType, user, inputs, triggers, monitorIds, ruleIndex, alertsIndex, alertsHistoryIndex, alertsHistoryIndexPattern, findingsIndex, findingsIndexPattern, rulePerMonitor, workflowIds, enableThreatIntel);
    }

    public static Detector readFrom(StreamInput sin) throws IOException {
        return new Detector(sin);
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    public String getDetectorType() {
        return this.logType.toLowerCase(Locale.ROOT);
    }

    public User getUser() {
        return this.user;
    }

    public List<DetectorInput> getInputs() {
        return this.inputs;
    }

    public List<DetectorTrigger> getTriggers() {
        return this.triggers;
    }

    public String getRuleIndex() {
        return this.ruleIndex;
    }

    public String getAlertsIndex() {
        return this.alertsIndex;
    }

    public String getAlertsHistoryIndex() {
        return this.alertsHistoryIndex;
    }

    public String getAlertsHistoryIndexPattern() {
        return this.alertsHistoryIndexPattern;
    }

    public String getFindingsIndex() {
        return this.findingsIndex;
    }

    public String getFindingsIndexPattern() {
        return this.findingsIndexPattern;
    }

    public List<String> getMonitorIds() {
        return this.monitorIds;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Map<String, String> getRuleIdMonitorIdMap() {
        return this.ruleIdMonitorIdMap;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setRuleIndex(String ruleIndex) {
        this.ruleIndex = ruleIndex;
    }

    public void setAlertsIndex(String alertsIndex) {
        this.alertsIndex = alertsIndex;
    }

    public void setAlertsHistoryIndex(String alertsHistoryIndex) {
        this.alertsHistoryIndex = alertsHistoryIndex;
    }

    public void setAlertsHistoryIndexPattern(String alertsHistoryIndexPattern) {
        this.alertsHistoryIndexPattern = alertsHistoryIndexPattern;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledTime(Instant enabledTime) {
        this.enabledTime = enabledTime;
    }

    public void setFindingsIndex(String findingsIndex) {
        this.findingsIndex = findingsIndex;
    }

    public void setFindingsIndexPattern(String findingsIndexPattern) {
        this.findingsIndexPattern = findingsIndexPattern;
    }

    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setInputs(List<DetectorInput> inputs) {
        this.inputs = inputs;
    }

    public void setMonitorIds(List<String> monitorIds) {
        this.monitorIds = monitorIds;
    }

    public void setRuleIdMonitorIdMap(Map<String, String> ruleIdMonitorIdMap) {
        this.ruleIdMonitorIdMap = ruleIdMonitorIdMap;
    }

    public void setWorkflowIds(List<String> workflowIds) {
        this.workflowIds = workflowIds;
    }

    public void setThreatIntelEnabled(boolean threatIntelEnabled) {
        this.threatIntelEnabled = threatIntelEnabled;
    }

    public List<String> getWorkflowIds() {
        return this.workflowIds;
    }

    public String getDocLevelMonitorId() {
        return this.ruleIdMonitorIdMap.get(DOC_LEVEL_MONITOR);
    }

    public boolean isWorkflowSupported() {
        return this.workflowIds != null && !this.workflowIds.isEmpty();
    }

    public Boolean getThreatIntelEnabled() {
        return this.threatIntelEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Detector detector = (Detector)o;
        return Objects.equals(this.id, detector.id) && Objects.equals(this.version, detector.version) && Objects.equals(this.name, detector.name) && Objects.equals(this.enabled, detector.enabled) && Objects.equals(this.schedule, detector.schedule) && Objects.equals(this.lastUpdateTime, detector.lastUpdateTime) && Objects.equals(this.enabledTime, detector.enabledTime) && Objects.equals(this.logType, detector.logType) && (this.user == null && detector.user == null || Objects.equals(this.user, detector.user)) && Objects.equals(this.inputs, detector.inputs) && Objects.equals(this.triggers, detector.triggers) && Objects.equals(this.type, detector.type) && Objects.equals(this.monitorIds, detector.monitorIds) && Objects.equals(this.ruleIndex, detector.ruleIndex);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.name, this.enabled, this.schedule, this.lastUpdateTime, this.enabledTime, this.logType, this.user, this.inputs, this.triggers, this.type, this.monitorIds, this.ruleIndex);
    }
}

