/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.action.LTRStatsAction;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.ltr.stats.LTRStat;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportLTRStatsAction
extends TransportNodesAction<LTRStatsAction.LTRStatsNodesRequest, LTRStatsAction.LTRStatsNodesResponse, LTRStatsAction.LTRStatsNodeRequest, LTRStatsAction.LTRStatsNodeResponse> {
    private final LTRStats ltrStats;

    @Inject
    public TransportLTRStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, LTRStats ltrStats) {
        super("cluster:admin/ltr/stats", threadPool, clusterService, transportService, actionFilters, LTRStatsAction.LTRStatsNodesRequest::new, LTRStatsAction.LTRStatsNodeRequest::new, "management", LTRStatsAction.LTRStatsNodeResponse.class);
        this.ltrStats = ltrStats;
    }

    protected LTRStatsAction.LTRStatsNodesResponse newResponse(LTRStatsAction.LTRStatsNodesRequest request, List<LTRStatsAction.LTRStatsNodeResponse> nodeResponses, List<FailedNodeException> failures) {
        Set<String> statsToBeRetrieved = request.getStatsToBeRetrieved();
        Map<String, Object> clusterStats = this.ltrStats.getClusterStats().entrySet().stream().filter(e -> statsToBeRetrieved.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((LTRStat)e.getValue()).getValue()));
        return new LTRStatsAction.LTRStatsNodesResponse(this.clusterService.getClusterName(), nodeResponses, failures, clusterStats);
    }

    protected LTRStatsAction.LTRStatsNodeRequest newNodeRequest(LTRStatsAction.LTRStatsNodesRequest request) {
        return new LTRStatsAction.LTRStatsNodeRequest(request);
    }

    protected LTRStatsAction.LTRStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new LTRStatsAction.LTRStatsNodeResponse(in);
    }

    protected LTRStatsAction.LTRStatsNodeResponse nodeOperation(LTRStatsAction.LTRStatsNodeRequest request) {
        LTRStatsAction.LTRStatsNodesRequest nodesRequest = request.getLTRStatsNodesRequest();
        Set<String> statsToBeRetrieved = nodesRequest.getStatsToBeRetrieved();
        Map<String, Object> statValues = this.ltrStats.getNodeStats().entrySet().stream().filter(e -> statsToBeRetrieved.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((LTRStat)e.getValue()).getValue()));
        return new LTRStatsAction.LTRStatsNodeResponse(this.clusterService.localNode(), statValues);
    }
}

