/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.OptimizedFeatureSet;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class StoredFeatureSet
implements FeatureSet,
Accountable,
StorableElement {
    public static final int MAX_FEATURES = 10000;
    public static final String TYPE = "featureset";
    private final long BASE_RAM_USED = RamUsageEstimator.shallowSizeOfInstance(StoredFeatureSet.class);
    private final String name;
    private final Map<String, Integer> featureMap;
    private final List<StoredFeature> features;
    private static final ObjectParser<ParsingState, Void> PARSER;
    static final ParseField NAME;
    static final ParseField FEATURES;

    public static StoredFeatureSet parse(XContentParser parser) {
        return StoredFeatureSet.parse(parser, null);
    }

    public static StoredFeatureSet parse(XContentParser parser, String name) {
        try {
            ParsingState state = (ParsingState)PARSER.apply(parser, null);
            state.resolveName(parser, name);
            if (state.features == null) {
                state.features = Collections.emptyList();
            }
            return new StoredFeatureSet(state.getName(), state.features);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
        }
    }

    public StoredFeatureSet(String name, List<StoredFeature> features) {
        this.name = Objects.requireNonNull(name);
        features = Objects.requireNonNull(features);
        if (!(features instanceof RandomAccess)) {
            features = new ArrayList<StoredFeature>(features);
        }
        this.features = features;
        this.featureMap = new HashMap<String, Integer>();
        int ordinal = -1;
        for (StoredFeature feature : features) {
            if (this.featureMap.put(feature.name(), ++ordinal) == null) continue;
            throw new IllegalArgumentException("Feature [" + feature.name() + "] defined twice in this set: feature names must be unique in a set.");
        }
    }

    @Override
    public FeatureSet optimize() {
        ArrayList<Feature> optimizedFeatures = new ArrayList<Feature>(this.features.size());
        boolean optimized = false;
        for (StoredFeature feature : this.features) {
            Feature optimizedFeature = feature.optimize();
            optimized |= optimizedFeature != feature;
            optimizedFeatures.add(optimizedFeature);
        }
        if (optimized) {
            return new OptimizedFeatureSet(this.name, optimizedFeatures, Collections.unmodifiableMap(this.featureMap));
        }
        return this;
    }

    @Override
    public void validate() {
        for (StoredFeature feature : this.features) {
            feature.validate(this);
        }
    }

    public StoredFeatureSet(StreamInput input) throws IOException {
        this(input.readString(), input.readList(StoredFeature::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeList(this.features);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.startArray(FEATURES.getPreferredName());
        for (StoredFeature feature : this.features) {
            feature.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public StoredFeatureSet append(List<StoredFeature> features) {
        int nFeature = features.size() + this.features.size();
        if (nFeature > 10000) {
            throw new IllegalArgumentException("The resulting feature set would be too large");
        }
        ArrayList<StoredFeature> newFeatures = new ArrayList<StoredFeature>(nFeature);
        newFeatures.addAll(this.features);
        newFeatures.addAll(features);
        return new StoredFeatureSet(this.name, newFeatures);
    }

    public StoredFeatureSet merge(List<StoredFeature> mergedFeatures) {
        int merged = (int)mergedFeatures.stream().map(StoredFeature::name).filter(this::hasFeature).count();
        if (this.size() + (mergedFeatures.size() - merged) > 10000) {
            throw new IllegalArgumentException("The resulting feature set would be too large");
        }
        ArrayList<StoredFeature> newFeatures = new ArrayList<StoredFeature>(this.features.size() + mergedFeatures.size() - merged);
        newFeatures.addAll(this.features);
        for (StoredFeature f : mergedFeatures) {
            if (this.hasFeature(f.name())) {
                newFeatures.set(this.featureOrdinal(f.name()), f);
                continue;
            }
            newFeatures.add(f);
        }
        assert (newFeatures.size() <= 10000);
        return new StoredFeatureSet(this.name, newFeatures);
    }

    @Override
    public List<Query> toQueries(LtrQueryContext context, Map<String, Object> params) {
        ArrayList<Query> queries = new ArrayList<Query>(this.features.size());
        for (Feature feature : this.features) {
            if (context.isFeatureActive(feature.name())) {
                queries.add(feature.doToQuery(context, this, params));
                continue;
            }
            queries.add((Query)new MatchNoDocsQuery("Feature " + feature.name() + " deactivated"));
        }
        return queries;
    }

    @Override
    public int featureOrdinal(String featureName) {
        Integer ordinal = this.featureMap.get(featureName);
        if (ordinal == null) {
            throw new IllegalArgumentException("Unknown feature [" + featureName + "]");
        }
        return ordinal;
    }

    @Override
    public StoredFeature feature(int ord) {
        return this.features.get(ord);
    }

    @Override
    public StoredFeature feature(String featureName) {
        return this.features.get(this.featureOrdinal(featureName));
    }

    @Override
    public boolean hasFeature(String featureName) {
        return this.featureMap.containsKey(featureName);
    }

    @Override
    public int size() {
        return this.features.size();
    }

    public long ramBytesUsed() {
        return this.BASE_RAM_USED + (long)(this.featureMap.size() * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.features.stream().mapToLong(StoredFeature::ramBytesUsed).sum();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoredFeatureSet)) {
            return false;
        }
        StoredFeatureSet that = (StoredFeatureSet)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.features.equals(that.features);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.features.hashCode();
        return result;
    }

    static {
        NAME = new ParseField("name", new String[0]);
        FEATURES = new ParseField("features", new String[0]);
        PARSER = new ObjectParser(TYPE, ParsingState::new);
        PARSER.declareString(StorableElement.StorableElementParserState::setName, NAME);
        PARSER.declareObjectArray(ParsingState::setFeatures, (p, c) -> StoredFeature.parse(p), FEATURES);
    }

    private static class ParsingState
    extends StorableElement.StorableElementParserState {
        private List<StoredFeature> features;

        private ParsingState() {
        }

        public void setFeatures(List<StoredFeature> features) {
            this.features = features;
        }
    }
}

