/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorInitializationFlagKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.editor.completion.JupyterMagicLookupElement;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.parsing.console.PyConsoleTokenTypes;
import com.jetbrains.python.psi.PyExpressionStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/py/editor/completion/JupyterMagicCommandsContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "isCellMagicAllowed", "", "cell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "prefix", "", "offset", "", "createPrefix", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "Companion", "intellij.jupyter.py"})
public final class JupyterMagicCommandsContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double LINE_MAGIC_COMPLETION_PRIORITY = 100.0;
    private static final double CELL_MAGIC_COMPLETION_PRIORITY = 50.0;
    @NotNull
    private static final Set<String> lineMagicSet;
    @NotNull
    private static final Set<String> cellMagicSet;

    public JupyterMagicCommandsContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result2) {
                VirtualFile virtualFile;
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                        Editor editor = parameters.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                        if (!JupyterEditorInitializationFlagKt.isJupyterInitialized((Editor)editor)) {
                            return;
                        }
                        virtualFile = parameters.getOriginalFile().getVirtualFile();
                        if (virtualFile == null) break block8;
                        VirtualFile virtualFile2 = virtualFile;
                        BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
                        VirtualFile p0 = virtualFile2;
                        boolean bl = false;
                        BackedNotebookVirtualFile backedNotebookVirtualFile = companion.takeIfBacked(p0);
                        virtualFile = backedNotebookVirtualFile;
                        if (backedNotebookVirtualFile != null) break block9;
                    }
                    return;
                }
                VirtualFile notebookVirtualFile = virtualFile;
                Project project = parameters.getEditor().getProject();
                Intrinsics.checkNotNull((Object)project);
                JupyterPsiCell jupyterPsiCell = JupyterHelper.INSTANCE.getPsiCellByOffset(project, (BackedNotebookVirtualFile)notebookVirtualFile, parameters.getOffset());
                if (jupyterPsiCell == null) {
                    return;
                }
                JupyterPsiCell cell = jupyterPsiCell;
                String string = this.createPrefix(parameters);
                if (string == null) {
                    return;
                }
                String prefix = string;
                boolean isCellMagicAllowed = this.isCellMagicAllowed(cell, prefix, parameters.getOffset());
                try {
                    Callable<Unit> callable = () -> 1.addCompletions$lambda$4(result2, prefix, isCellMagicAllowed);
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
                    Unit cfr_ignored_0 = (Unit)ApplicationUtil.runWithCheckCanceled(callable, (ProgressIndicator)progressIndicator);
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit addCompletions$lambda$4(CompletionResultSet $result, String $prefix, boolean $isCellMagicAllowed) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                String it;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv = Companion.getLineMagicSet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)$prefix, (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(PrioritizedLookupElement.withPriority((LookupElement)new JupyterMagicLookupElement(it), (double)100.0));
                }
                List magicLineCompletion = (List)destination$iv$iv;
                $result.withPrefixMatcher($prefix).addAllElements((Iterable)magicLineCompletion);
                if (!$isCellMagicAllowed) {
                    return Unit.INSTANCE;
                }
                Iterable $this$filter$iv2 = Companion.getCellMagicSet();
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it2, (String)$prefix, (boolean)false, (int)2, null)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                boolean $i$f$map2 = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it2 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(PrioritizedLookupElement.withPriority((LookupElement)new JupyterMagicLookupElement(it2), (double)50.0));
                }
                List magicCellCompletion = (List)destination$iv$iv2;
                $result.withPrefixMatcher($prefix).addAllElements((Iterable)magicCellCompletion);
                return Unit.INSTANCE;
            }
        });
    }

    private final boolean isCellMagicAllowed(JupyterPsiCell cell, String prefix, int offset) {
        String string = cell.getSource().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = 0;
        JupyterSource jupyterSource = cell.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)jupyterSource, (String)"<get-source>(...)");
        int n2 = offset - PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)jupyterSource));
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String cellSourceBeforeCaret = string3;
        String string4 = cellSourceBeforeCaret.substring(0, cellSourceBeforeCaret.length() - prefix.length());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String cellSourceBeforeElement = string4;
        return StringsKt.isBlank((CharSequence)cellSourceBeforeElement);
    }

    private final String createPrefix(CompletionParameters parameters) {
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement currentElement = psiElement;
        String string = currentElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = 0;
        int n2 = parameters.getOffset() - currentElement.getTextRange().getStartOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String contentInside = string3;
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)currentElement), (Object)PyConsoleTokenTypes.MAGIC_COMMAND_LINE) || currentElement.getPrevSibling() == null && currentElement.getParent().getParent() instanceof PyExpressionStatement) {
            return contentInside;
        }
        return null;
    }

    static {
        Object[] objectArray = new String[]{"%alias", "%alias_magic", "%autoawait", "%autocall", "%automagic", "%autosave", "%bookmark", "%cat", "%cd", "%clear", "%colors", "%conda", "%config", "%connect_info", "%cp", "%debug", "%dhist", "%dirs", "%doctest_mode", "%ed", "%edit", "%env", "%gui", "%hist", "%history", "%killbgscripts", "%ldir", "%less", "%lf", "%lk", "%ll", "%load", "%load_ext", "%loadpy", "%logoff", "%logon", "%logstart", "%logstate", "%logstop", "%ls", "%lsmagic", "%ls", "%macro", "%magic", "%man", "%matplotlib", "%mkdir", "%more", "%mv", "%notebook", "%page", "%pastebin", "%pdb", "%pdef", "%pdoc", "%pfile", "%pinfo", "%pinfo2", "%pip", "%popd", "%pprint", "%precision", "%prun", "%psearch", "%psource", "%pushd", "%pwd", "%pycat", "%pylab", "%qqtconsole", "%quickref", "%recall", "%rehashx", "%reload_ext", "%rep", "%rerun", "%reset", "%reset_selective", "%rm", "%rmdir", "%run", "%save", "%sc", "%set_env", "%store", "%sx", "%system", "%tb", "%time", "%timeit", "%unalias", "%unload_ext", "%who", "%who_ls", "%whos", "%xdel", "%xmode"};
        lineMagicSet = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"%%!", "%%HTML", "%%SVG", "%%bash", "%%cmd", "%%capture", "%%debug", "%%file", "%%html", "%%javascript", "%%js", "%%latex", "%%markdown", "%%perl", "%%prun", "%%pypy", "%%python", "%%python2", "%%python3", "%%ruby", "%%script", "%%sh", "%%svg", "%%sx", "%%time", "%%timeit", "%%writefile"};
        cellMagicSet = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/py/editor/completion/JupyterMagicCommandsContributor$Companion;", "", "<init>", "()V", "LINE_MAGIC_COMPLETION_PRIORITY", "", "CELL_MAGIC_COMPLETION_PRIORITY", "lineMagicSet", "", "", "getLineMagicSet", "()Ljava/util/Set;", "cellMagicSet", "getCellMagicSet", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getLineMagicSet() {
            return lineMagicSet;
        }

        @NotNull
        public final Set<String> getCellMagicSet() {
            return cellMagicSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

