/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search;

import java.io.File;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class SearchFilterDefinition {
    private static final Logger LOG = Logger.getLogger(SearchFilterDefinition.class.getName());

    public abstract boolean searchFile(@NonNull FileObject var1) throws IllegalArgumentException;

    @NonNull
    public abstract FolderResult traverseFolder(@NonNull FileObject var1) throws IllegalArgumentException;

    public boolean searchFile(@NonNull URI uRI) {
        File file = null;
        try {
            file = new File(uRI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.log(Level.INFO, null, illegalArgumentException);
            return false;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return false;
        }
        return this.searchFile(fileObject);
    }

    @NonNull
    public FolderResult traverseFolder(@NonNull URI uRI) throws IllegalArgumentException {
        File file = null;
        try {
            file = new File(uRI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.log(Level.INFO, null, illegalArgumentException);
            return FolderResult.DO_NOT_TRAVERSE;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return FolderResult.DO_NOT_TRAVERSE;
        }
        return this.traverseFolder(fileObject);
    }

    public static enum FolderResult {
        DO_NOT_TRAVERSE,
        TRAVERSE,
        TRAVERSE_ALL_SUBFOLDERS;

    }
}

