/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.query.Container;
import ca.sqlpower.query.Item;
import ca.sqlpower.query.Query;
import ca.sqlpower.query.QueryChangeEvent;
import ca.sqlpower.query.QueryChangeListener;
import ca.sqlpower.query.SQLJoin;
import ca.sqlpower.query.TableContainer;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.CursorManager;
import ca.sqlpower.swingui.dbtree.SQLObjectSelection;
import ca.sqlpower.swingui.querypen.CleanupPNode;
import ca.sqlpower.swingui.querypen.ConstantsPane;
import ca.sqlpower.swingui.querypen.ContainerPane;
import ca.sqlpower.swingui.querypen.JoinLine;
import ca.sqlpower.swingui.querypen.MouseState;
import ca.sqlpower.swingui.querypen.UnmodifiableItemPNode;
import ca.sqlpower.swingui.querypen.event.CreateJoinEventHandler;
import ca.sqlpower.swingui.querypen.event.QueryPenSelectionEventHandler;
import ca.sqlpower.util.TransactionEvent;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class QueryPen
implements MouseState {
    private static Logger logger = Logger.getLogger(QueryPen.class);
    private static final Color SELECTION_COLOUR = new Color(-869059789);
    private static final String DELETE_ACTION = "Delete";
    private static final String BACKSPACE_ACTION = "Backspace";
    private static final String ZOOM_IN_ACTION = "Zoom In";
    private static final String ZOOM_OUT_ACTION = "Zoom Out";
    private static final String JOIN_ACTION = "Create Join";
    public static final Color SELECTED_CONTAINER_COLOUR = new Color(0xFF9900);
    public static final Color SELECTED_CONTAINER_GRADIENT_COLOUR = new Color(0xFFCC66);
    public static final Color UNSELECTED_CONTAINER_COLOUR = new Color(0x999999);
    public static final Color UNSELECTED_CONTAINER_GRADIENT_COLOUR = new Color(0xCCCCCC);
    public static final float CONTAINER_ROUND_CORNER_RADIUS = 8.0f;
    public static final Color WHERE_BACKGROUND_COLOUR = new Color(0xEEEEEE);
    private static final String QUERY_EXECUTE = "Execute";
    private JPanel panel;
    private AbstractAction zoomInAction;
    private AbstractAction zoomOutAction;
    private static final float SELECTION_TRANSPARENCY = 0.33f;
    private final JScrollPane scrollPane;
    private final PSwingCanvas canvas;
    private final PLayer joinLayer;
    private final PLayer topLayer;
    private final JButton createJoinButton;
    private final JTextField globalWhereText;
    private final String acceleratorKeyString;
    private final Query model;
    private MouseState.MouseStates mouseState = MouseState.MouseStates.READY;
    private QueryPenSelectionEventHandler selectionEventHandler;
    private final CursorManager cursorManager;
    private ConstantsPane constantsContainer;
    private JSlider zoomSlider;
    private JPanel zoomSliderContainer;
    private final Action executeQueryAction;
    private final Action deleteAction = new AbstractAction(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                QueryPen.this.model.startCompoundEdit("Deleting objects from the query pen.");
                for (PNode pickedNode : QueryPen.this.selectionEventHandler.getSelection()) {
                    if (pickedNode.getParent() == QueryPen.this.topLayer) {
                        if (pickedNode == QueryPen.this.constantsContainer) {
                            return;
                        }
                        if (pickedNode instanceof ContainerPane) {
                            ContainerPane pane = (ContainerPane)pickedNode;
                            QueryPen.this.deleteContainer(pane);
                        }
                    }
                    if (pickedNode.getParent() != QueryPen.this.joinLayer) continue;
                    QueryPen.this.deleteJoinLine((JoinLine)pickedNode);
                }
            }
            finally {
                QueryPen.this.model.endCompoundEdit();
            }
        }
    };
    private List<PropertyChangeListener> queryListeners = new ArrayList<PropertyChangeListener>();
    private PropertyChangeListener queryChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            logger.debug((Object)"Query pen received state change.");
            for (PropertyChangeListener l : QueryPen.this.queryListeners) {
                l.propertyChange(evt);
            }
        }
    };
    private CreateJoinEventHandler joinCreationListener;
    private final JButton playPenExecuteButton;
    private final JButton deleteButton;
    private final JButton resetButton;
    private final Action resetAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryPen.this.model.reset();
        }
    };
    private JToolBar queryPenToolBar;
    private final QueryChangeListener queryListener = new QueryChangeListener(){

        @Override
        public void propertyChangeEvent(PropertyChangeEvent evt) {
        }

        @Override
        public void joinRemoved(QueryChangeEvent evt) {
            SQLJoin removedJoin = evt.getJoinChanged();
            for (Object node : QueryPen.this.joinLayer.getAllNodes()) {
                if (!(node instanceof JoinLine) || ((JoinLine)node).getModel() != removedJoin) continue;
                JoinLine pickedNode = (JoinLine)node;
                pickedNode.disconnectJoin();
                QueryPen.this.joinLayer.removeChild((PNode)pickedNode);
                break;
            }
        }

        @Override
        public void joinPropertyChangeEvent(PropertyChangeEvent evt) {
        }

        @Override
        public void joinAdded(QueryChangeEvent evt) {
            SQLJoin sqlJoin = evt.getJoinChanged();
            JoinLine join = new JoinLine(QueryPen.this, (PCanvas)QueryPen.this.canvas, sqlJoin);
            QueryPen.this.joinLayer.addChild((PNode)join);
        }

        @Override
        public void itemRemoved(QueryChangeEvent evt) {
        }

        @Override
        public void itemPropertyChangeEvent(PropertyChangeEvent evt) {
        }

        @Override
        public void itemAdded(QueryChangeEvent evt) {
        }

        @Override
        public void containerRemoved(QueryChangeEvent evt) {
            Container removedContainer = evt.getContainerChanged();
            ContainerPane removedPane = null;
            for (int i = 0; i < QueryPen.this.topLayer.getChildrenCount(); ++i) {
                PNode child = QueryPen.this.topLayer.getChild(i);
                if (!(child instanceof ContainerPane) || !((ContainerPane)child).getModel().equals(removedContainer)) continue;
                removedPane = (ContainerPane)child;
                break;
            }
            if (removedPane == null) {
                JOptionPane.showMessageDialog((Component)QueryPen.this.getCanvas(), "Cannot find the table " + removedContainer.getName() + " to remove from the query pen.", "Cannot find table.", 0);
                return;
            }
            QueryPen.this.topLayer.removeChild(removedPane);
            removedPane.removeQueryChangeListener(QueryPen.this.queryChangeListener);
        }

        @Override
        public void containerAdded(QueryChangeEvent evt) {
            Container containerChanged = evt.getContainerChanged();
            ContainerPane pane = new ContainerPane(QueryPen.this, (PCanvas)QueryPen.this.canvas, containerChanged, QueryPen.this.variablesHelper);
            pane.addQueryChangeListener(QueryPen.this.queryChangeListener);
            QueryPen.this.topLayer.addChild((PNode)pane);
            QueryPen.this.canvas.repaint();
        }

        @Override
        public void compoundEditEnded(TransactionEvent evt) {
        }

        @Override
        public void compoundEditStarted(TransactionEvent evt) {
        }
    };
    private final Action joinAction;
    private SPVariableHelper variablesHelper;

    public void deleteContainer(ContainerPane pickedNode) {
        this.model.removeTable(pickedNode.getModel());
    }

    public void deleteJoinLine(JoinLine pickedNode) {
        this.model.removeJoin(pickedNode.getModel());
    }

    public JPanel createQueryPen() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.getScrollPane(), "Center");
        this.getPlayPenExecuteButton().setToolTipText("Execute(Shortcut " + this.getAcceleratorKeyString() + " R)");
        this.canvas.getInputMap(1).put(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), QUERY_EXECUTE);
        this.canvas.getActionMap().put(QUERY_EXECUTE, this.executeQueryAction);
        this.panel.setBackground(Color.WHITE);
        return this.panel;
    }

    private JToolBar createToolBar() {
        JToolBar queryPenBarChild = new JToolBar(0);
        queryPenBarChild.setFloatable(false);
        queryPenBarChild.add(this.getPlayPenExecuteButton());
        queryPenBarChild.addSeparator();
        queryPenBarChild.add(this.getResetButton());
        queryPenBarChild.add(this.getDeleteButton());
        queryPenBarChild.add(this.getCreateJoinButton());
        queryPenBarChild.addSeparator();
        queryPenBarChild.add(this.getZoomSliderContainer());
        queryPenBarChild.addSeparator();
        return queryPenBarChild;
    }

    public QueryPen(Action executeQueryAction, Query model) {
        this(executeQueryAction, model, true);
    }

    public QueryPen(Action executeQueryAction, Query model, boolean showConstantContainer) {
        this.playPenExecuteButton = new JButton(executeQueryAction);
        this.deleteButton = new JButton(this.getDeleteAction());
        this.resetButton = new JButton(this.getResetAction());
        ImageIcon deleteIcon = new ImageIcon(QueryPen.class.getClassLoader().getResource("ca/sqlpower/swingui/querypen/delete.png"));
        this.getDeleteButton().setToolTipText("Delete (Shortcut Delete)");
        this.getDeleteButton().setIcon(deleteIcon);
        this.executeQueryAction = executeQueryAction;
        this.model = model;
        model.addQueryChangeListener(this.queryListener);
        this.panel = new JPanel();
        this.cursorManager = new CursorManager(this.panel);
        this.acceleratorKeyString = System.getProperty("os.name").toLowerCase().startsWith("mac os x") ? "Cmd" : "Ctrl";
        this.variablesHelper = model instanceof SPObject ? new SPVariableHelper((SPObject)((Object)model)) : null;
        this.canvas = new PSwingCanvas();
        this.canvas.setBackground(Color.black);
        this.canvas.setAnimatingRenderQuality(1);
        this.canvas.setInteractingRenderQuality(1);
        this.scrollPane = new PScrollPane((Component)this.canvas);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.canvas.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), DELETE_ACTION);
        this.canvas.getActionMap().put(DELETE_ACTION, this.getDeleteAction());
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            this.canvas.getInputMap(1).put(KeyStroke.getKeyStroke(8, 0), BACKSPACE_ACTION);
            this.canvas.getActionMap().put(BACKSPACE_ACTION, this.getDeleteAction());
        }
        this.canvas.setPanEventHandler(null);
        this.topLayer = this.canvas.getLayer();
        this.joinLayer = new PLayer();
        this.canvas.getRoot().addChild((PNode)this.joinLayer);
        this.canvas.getCamera().addLayer(0, this.joinLayer);
        int defaultSliderValue = 500;
        this.zoomSlider = new JSlider(0, 1, 1000, 500);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double newScale = (double)QueryPen.this.zoomSlider.getValue() / 500.0;
                PCamera camera = QueryPen.this.canvas.getCamera();
                double oldScale = camera.getViewScale();
                camera.scaleViewAboutPoint(newScale / oldScale, camera.getViewBounds().getCenterX(), camera.getViewBounds().getCenterY());
                logger.debug((Object)("Camera scaled by " + newScale / oldScale + " and is now at " + camera.getViewScale()));
            }
        });
        this.zoomSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0) {
                    QueryPen.this.zoomSlider.setValue(500);
                }
            }
        });
        this.zoomInAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryPen.this.zoomSlider.setValue(QueryPen.this.zoomSlider.getValue() + 50);
            }
        };
        this.zoomSliderContainer = new JPanel(new BorderLayout());
        this.zoomSliderContainer.setMaximumSize(new Dimension((int)this.zoomSlider.getPreferredSize().getWidth(), 200));
        this.zoomSliderContainer.add((Component)this.zoomSlider, "Center");
        this.zoomSliderContainer.add((Component)new JLabel(new ImageIcon(QueryPen.class.getClassLoader().getResource("ca/sqlpower/swingui/querypen/zoom_in16.png"))), "East");
        this.zoomSliderContainer.add((Component)new JLabel(new ImageIcon(QueryPen.class.getClassLoader().getResource("ca/sqlpower/swingui/querypen/zoom_out16.png"))), "West");
        this.panel.getInputMap(1).put(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1), ZOOM_IN_ACTION);
        this.panel.getActionMap().put(ZOOM_IN_ACTION, this.zoomInAction);
        this.zoomOutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryPen.this.zoomSlider.setValue(QueryPen.this.zoomSlider.getValue() - 50);
            }
        };
        this.panel.getInputMap(1).put(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1), ZOOM_OUT_ACTION);
        this.panel.getActionMap().put(ZOOM_OUT_ACTION, this.zoomOutAction);
        ImageIcon joinIcon = new ImageIcon(QueryPen.class.getClassLoader().getResource("ca/sqlpower/swingui/querypen/j.png"));
        this.joinAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryPen.this.setMouseState(MouseState.MouseStates.CREATE_JOIN);
                QueryPen.this.cursorManager.placeModeStarted();
            }
        };
        this.createJoinButton = new JButton(this.getJoinAction());
        this.createJoinButton.setToolTipText("Create Join (Shortcut " + this.acceleratorKeyString + " J)");
        this.createJoinButton.setIcon(joinIcon);
        this.canvas.getInputMap(1).put(KeyStroke.getKeyStroke(74, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), JOIN_ACTION);
        this.canvas.getActionMap().put(JOIN_ACTION, this.getJoinAction());
        this.joinCreationListener = new CreateJoinEventHandler(this, (PCanvas)this.canvas, this.cursorManager);
        this.canvas.addInputEventListener((PInputEventListener)this.joinCreationListener);
        this.joinCreationListener.addCreateJoinListener(this.queryChangeListener);
        new DropTarget((Component)this.canvas, new QueryPenDropTargetListener());
        ArrayList<PLayer> layerList = new ArrayList<PLayer>();
        layerList.add(this.topLayer);
        layerList.add(this.joinLayer);
        this.selectionEventHandler = new QueryPenSelectionEventHandler((PNode)this.topLayer, layerList);
        this.selectionEventHandler.setMarqueePaint(SELECTION_COLOUR);
        this.selectionEventHandler.setMarqueePaintTransparency(0.33f);
        this.canvas.addInputEventListener((PInputEventListener)this.selectionEventHandler);
        this.globalWhereText = new JTextField();
        this.globalWhereText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                QueryPen.this.queryChangeListener.propertyChange(new PropertyChangeEvent(QueryPen.this.globalWhereText, "WHERE_MODIFIED", QueryPen.this.globalWhereText.getText(), QueryPen.this.globalWhereText.getText()));
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.globalWhereText.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    QueryPen.this.queryChangeListener.propertyChange(new PropertyChangeEvent(QueryPen.this.globalWhereText, "WHERE_MODIFIED", QueryPen.this.globalWhereText.getText(), QueryPen.this.globalWhereText.getText()));
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.setQueryPenToolBar(this.createToolBar());
        this.loadQueryCache(showConstantContainer);
    }

    private void loadQueryCache(boolean showConstantContainer) {
        this.constantsContainer = new ConstantsPane(this, (PCanvas)this.canvas, this.model.getConstantsContainer(), this.variablesHelper);
        this.constantsContainer.addChangeListener(this.queryChangeListener);
        if (showConstantContainer) {
            this.topLayer.addChild((PNode)this.constantsContainer);
        }
        HashMap<Item, UnmodifiableItemPNode> loadedItemPNodes = new HashMap<Item, UnmodifiableItemPNode>();
        for (Container c : this.model.getFromTableList()) {
            ContainerPane container = new ContainerPane(this, (PCanvas)this.canvas, c, this.variablesHelper);
            this.topLayer.addChild((PNode)container);
            for (UnmodifiableItemPNode node : container.getContainedItems()) {
                loadedItemPNodes.put(node.getItem(), node);
            }
        }
        for (SQLJoin join : this.model.getJoins()) {
            this.joinLayer.addChild((PNode)new JoinLine(this, (PCanvas)this.canvas, join));
        }
    }

    public QueryPenSelectionEventHandler getMultipleSelectEventHandler() {
        return this.selectionEventHandler;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JSlider getZoomSlider() {
        return this.zoomSlider;
    }

    public JPanel getZoomSliderContainer() {
        return this.zoomSliderContainer;
    }

    public JButton getCreateJoinButton() {
        return this.createJoinButton;
    }

    public PSwingCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public MouseState.MouseStates getMouseState() {
        return this.mouseState;
    }

    public PLayer getJoinLayer() {
        return this.joinLayer;
    }

    public PLayer getTopLayer() {
        return this.topLayer;
    }

    @Override
    public synchronized void setMouseState(MouseState.MouseStates mouseState) {
        this.mouseState = mouseState;
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public Action getResetAction() {
        return this.resetAction;
    }

    public JTextField getGlobalWhereText() {
        return this.globalWhereText;
    }

    public CursorManager getCursorManager() {
        return this.cursorManager;
    }

    private List<Container> getContainerPane(SQLTable table) {
        ArrayList<Container> containerList = new ArrayList<Container>();
        for (Container node : this.model.getFromTableList()) {
            if (node.getContainedObject() != table) continue;
            containerList.add(node);
        }
        return containerList;
    }

    public void addQueryListener(PropertyChangeListener l) {
        this.queryListeners.add(l);
    }

    public void removeQueryListener(PropertyChangeListener l) {
        this.queryListeners.remove(l);
    }

    public Query getModel() {
        return this.model;
    }

    public String getAcceleratorKeyString() {
        return this.acceleratorKeyString;
    }

    public PSwingCanvas getQueryPenCanvas() {
        return this.canvas;
    }

    public void cleanup() {
        this.model.removeQueryChangeListener(this.queryListener);
        this.queryListeners.clear();
        for (Object o : this.topLayer.getAllNodes()) {
            if (!(o instanceof CleanupPNode)) continue;
            ((CleanupPNode)o).cleanup();
        }
        for (Object o : this.joinLayer.getAllNodes()) {
            if (!(o instanceof CleanupPNode)) continue;
            ((CleanupPNode)o).cleanup();
        }
    }

    public void setZoom(int zoomLevel) {
        if (zoomLevel > this.zoomSlider.getMinimum() && zoomLevel < this.zoomSlider.getMaximum()) {
            this.zoomSlider.setValue(zoomLevel);
        }
    }

    public JButton getPlayPenExecuteButton() {
        return this.playPenExecuteButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public void setQueryPenToolBar(JToolBar queryPenToolBar) {
        this.queryPenToolBar = queryPenToolBar;
    }

    public JToolBar getQueryPenToolBar() {
        return this.queryPenToolBar;
    }

    public void setExecuteIcon(ImageIcon icon) {
        this.getPlayPenExecuteButton().setIcon(icon);
    }

    public JButton getResetButton() {
        return this.resetButton;
    }

    public Action getExecuteQueryAction() {
        return this.executeQueryAction;
    }

    public Action getJoinAction() {
        return this.joinAction;
    }

    private final class QueryPenDropTargetListener
    implements DropTargetListener {
        private QueryPenDropTargetListener() {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            SQLTable table;
            SQLObject[] draggedObjects;
            if (!dtde.isLocalTransfer()) {
                logger.debug((Object)"Rejecting non-local transfer");
                dtde.rejectDrop();
                return;
            }
            if (!dtde.isDataFlavorSupported(SQLObjectSelection.LOCAL_SQLOBJECT_ARRAY_FLAVOUR)) {
                logger.debug((Object)"Rejecting transfer of unknown flavour");
                dtde.rejectDrop();
                return;
            }
            try {
                draggedObjects = (SQLObject[])dtde.getTransferable().getTransferData(SQLObjectSelection.LOCAL_SQLOBJECT_ARRAY_FLAVOUR);
            }
            catch (UnsupportedFlavorException e) {
                dtde.dropComplete(false);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                dtde.dropComplete(false);
                throw new RuntimeException(e);
            }
            SQLDatabase tableDatabase = null;
            int response = 0;
            for (SQLObject draggedSQLObject : draggedObjects) {
                if (draggedSQLObject instanceof SQLTable) {
                    table = (SQLTable)draggedSQLObject;
                    if (tableDatabase != null && !tableDatabase.equals(table.getParentDatabase())) {
                        JOptionPane.showMessageDialog(null, "The tables your are adding are from different database connections. This will cause errors in your query.", "Error", 0);
                        response = 1;
                    }
                } else {
                    logger.debug((Object)("Rejecting drop of non-SQLTable SQLObject: " + draggedSQLObject));
                    dtde.rejectDrop();
                    return;
                }
                tableDatabase = table.getParentDatabase();
            }
            if (!QueryPen.this.getModel().getDatabase().equals(tableDatabase) && response == 0) {
                Object[] options;
                String message = draggedObjects.length == 1 ? "The table being added is not from \"" + QueryPen.this.getModel().getDatabase() + "\"." : "The tables being added are not from \"" + QueryPen.this.getModel().getDatabase() + "\".";
                response = JOptionPane.showOptionDialog(null, message = message + "\nDo you want to change your connection to \"" + tableDatabase + "\"?\n" + "If so, your current query will be cleared and the new tables added.", "Warning", 0, 2, null, options = new String[]{"YES", "NO"}, options[1]);
                if (response == 0) {
                    QueryPen.this.model.setDataSource(tableDatabase.getDataSource());
                    QueryPen.this.model.reset();
                }
            }
            if (response == 0) {
                for (SQLObject draggedSQLObject : draggedObjects) {
                    try {
                        QueryPen.this.cursorManager.startWaitMode();
                        table = (SQLTable)draggedSQLObject;
                        QueryPen.this.model.startCompoundEdit("Table " + table.getName() + " was dropped " + "on the query pen, adding it to the mode.");
                        DatabaseMetaDataDecorator.putHint("cacheType", (Object)DatabaseMetaDataDecorator.CacheType.EAGER_CACHE);
                        TableContainer tableModel = new TableContainer(QueryPen.this.model.getDatabase(), table);
                        Point location = dtde.getLocation();
                        Point2D movedLoc = QueryPen.this.canvas.getCamera().localToView((Point2D)location);
                        tableModel.setPosition(movedLoc);
                        int aliasCounter = 0;
                        ArrayList<String> aliasNames = new ArrayList<String>();
                        for (Container existingTable : QueryPen.this.model.getFromTableList()) {
                            if (!tableModel.getName().equals(existingTable.getName())) continue;
                            logger.debug((Object)"Found same tableName, going to alias");
                            aliasNames.add(existingTable.getAlias());
                        }
                        Collections.sort(aliasNames);
                        for (String alias : aliasNames) {
                            if (!alias.equals(tableModel.getName() + "_" + aliasCounter) && !alias.equals("")) continue;
                            ++aliasCounter;
                        }
                        if (aliasCounter != 0) {
                            tableModel.setAlias(tableModel.getName() + "_" + aliasCounter);
                        }
                        QueryPen.this.model.addTable(tableModel);
                        try {
                            Item fkItemNode;
                            for (SQLRelationship relation : table.getExportedKeys()) {
                                List fkContainers = QueryPen.this.getContainerPane(relation.getFkTable());
                                for (Container fkContainer : fkContainers) {
                                    for (SQLRelationship.ColumnMapping mapping : relation.getChildren(SQLRelationship.ColumnMapping.class)) {
                                        logger.debug((Object)("PK container has model name " + tableModel.getName() + " looking for col named " + mapping.getPkColumn().getName()));
                                        Item pkItemNode = tableModel.getItem(mapping.getPkColumn());
                                        fkItemNode = fkContainer.getItem(mapping.getFkColumn());
                                        logger.debug((Object)("FK item node is " + fkItemNode));
                                        if (pkItemNode != null && fkItemNode != null) {
                                            if (pkItemNode.getParent() != fkItemNode.getParent()) {
                                                SQLJoin join = new SQLJoin(pkItemNode, fkItemNode);
                                                join.addJoinChangeListener(QueryPen.this.queryChangeListener);
                                                QueryPen.this.model.addJoin(join);
                                                continue;
                                            }
                                            logger.debug((Object)"we don't allow items joining on the same table");
                                            continue;
                                        }
                                        throw new IllegalStateException("Trying to join two columns, one of which does not exist");
                                    }
                                }
                            }
                            for (SQLRelationship.SQLImportedKey key : table.getImportedKeys()) {
                                SQLRelationship relation = key.getRelationship();
                                List pkContainers = QueryPen.this.getContainerPane(relation.getParent());
                                for (Container pkContainer : pkContainers) {
                                    for (SQLRelationship.ColumnMapping mapping : relation.getChildren(SQLRelationship.ColumnMapping.class)) {
                                        fkItemNode = pkContainer.getItem(mapping.getPkColumn());
                                        Item pkItemNode = tableModel.getItem(mapping.getFkColumn());
                                        if (pkItemNode != null && fkItemNode != null) {
                                            if (pkItemNode.getParent() != fkItemNode.getParent()) {
                                                SQLJoin join = new SQLJoin(fkItemNode, pkItemNode);
                                                join.addJoinChangeListener(QueryPen.this.queryChangeListener);
                                                QueryPen.this.model.addJoin(join);
                                                continue;
                                            }
                                            logger.debug((Object)"we don't allow items joining on the same table");
                                            continue;
                                        }
                                        throw new IllegalStateException("Trying to join two columns, one of which does not exist");
                                    }
                                }
                            }
                        }
                        catch (SQLObjectException e) {
                            throw new RuntimeException(e);
                        }
                        for (Item itemNode : tableModel.getItems()) {
                            QueryPen.this.model.selectItem(itemNode);
                        }
                        dtde.acceptDrop(dtde.getDropAction());
                        dtde.dropComplete(true);
                    }
                    finally {
                        QueryPen.this.cursorManager.finishWaitMode();
                        DatabaseMetaDataDecorator.putHint("cacheType", (Object)DatabaseMetaDataDecorator.CacheType.NO_CACHE);
                        QueryPen.this.model.endCompoundEdit();
                    }
                }
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }
    }
}

