/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Font;
import java.util.Comparator;
import java.util.function.Function;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportExplorationPanel
extends ReportPanel {
    private static final Comparator<Region> regionComparator = Comparator.comparingInt(r -> r.getDiscoveredIn().getNumber()).reversed().thenComparingInt(Region::getScoreValue).reversed();

    public ReportExplorationPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportExplorationAction");
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new MigLayout("wrap 5, fillx", "", ""));
        Font font = FontLibrary.getScaledFont("normal-bold-tiny");
        JLabel nameOfRegion = Utility.localizedLabel("report.exploration.nameOfRegion");
        nameOfRegion.setFont(font);
        this.reportPanel.add(nameOfRegion);
        JLabel typeOfRegion = Utility.localizedLabel("report.exploration.typeOfRegion");
        typeOfRegion.setFont(font);
        this.reportPanel.add(typeOfRegion);
        JLabel discoveredIn = Utility.localizedLabel("report.exploration.discoveredIn");
        discoveredIn.setFont(font);
        this.reportPanel.add(discoveredIn);
        JLabel discoveredBy = Utility.localizedLabel("report.exploration.discoveredBy");
        discoveredBy.setFont(font);
        this.reportPanel.add(discoveredBy);
        JLabel valueOfRegion = Utility.localizedLabel("report.exploration.valueOfRegion");
        valueOfRegion.setFont(font);
        this.reportPanel.add(valueOfRegion);
        for (Region region : CollectionUtils.transform(this.getMap().getRegions(), CollectionUtils.isNotNull(Region::getDiscoveredIn), Function.identity(), regionComparator)) {
            this.reportPanel.add(new JLabel(region.getName()));
            this.reportPanel.add(Utility.localizedLabel(region.getType().getNameKey()));
            this.reportPanel.add(Utility.localizedLabel(region.getDiscoveredIn().getLabel()));
            this.reportPanel.add(Utility.localizedLabel(region.getDiscoveredBy().getCountryLabel()));
            this.reportPanel.add(new JLabel(String.valueOf(region.getScoreValue())));
        }
    }
}

