/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.TurnTaker;

public class ServerBuilding
extends Building
implements TurnTaker {
    private static final Logger logger = Logger.getLogger(ServerBuilding.class.getName());

    public ServerBuilding(Game game, String id) {
        super(game, id);
    }

    public ServerBuilding(Game game, Colony colony, BuildingType type) {
        super(game, colony, type);
    }

    private void csTeach(ChangeSet cs) {
        Player owner = this.getColony().getOwner();
        for (Unit teacher : this.getUnitList()) {
            Unit student = teacher.getStudent();
            if (student != null && student.getTeacher() != teacher) {
                logger.warning("Bogus teacher/student assignment.");
                teacher.setStudent(null);
                student = null;
            }
            if (student == null && this.csAssignStudent(teacher, cs)) {
                student = teacher.getStudent();
            }
            teacher.setTurnsOfTraining(student == null ? 0 : teacher.getTurnsOfTraining() + 1);
            cs.add(ChangeSet.See.only(owner), teacher);
        }
    }

    public boolean csCheckTeach(Unit teacher, ChangeSet cs) {
        Player owner = this.getColony().getOwner();
        Unit student = teacher.getStudent();
        if (student != null && teacher.getTurnsOfTraining() >= teacher.getNeededTurnsOfTraining()) {
            this.csTrainStudent(teacher, student, cs);
            cs.add(ChangeSet.See.only(owner), student);
            if (teacher.getStudent() == null) {
                this.csAssignStudent(teacher, cs);
            }
            return true;
        }
        return false;
    }

    private boolean csTrainStudent(Unit teacher, Unit student, ChangeSet cs) {
        boolean ret;
        Player owner = this.getColony().getOwner();
        StringTemplate oldName = student.getLabel();
        UnitType skill = student.getTeachingType(teacher);
        boolean bl = ret = skill != null;
        if (skill == null) {
            logger.warning("Student " + student.getId() + " can not learn from " + teacher.getId());
        } else {
            student.changeType(skill);
            StringTemplate newName = student.getLabel();
            cs.addMessage(owner, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "model.building.unitEducated", this.getColony(), this).addStringTemplate("%oldName%", oldName)).addStringTemplate("%unit%", newName)).addName("%colony%", this.getColony().getName()));
        }
        student.setTurnsOfTraining(0);
        student.setMovesLeft(0);
        teacher.setTurnsOfTraining(0);
        teacher.setMovesLeft(0);
        if (!student.canBeStudent(teacher)) {
            student.setTeacher(null);
            teacher.setStudent(null);
        }
        return ret;
    }

    private boolean csAssignStudent(Unit teacher, ChangeSet cs) {
        Colony colony = this.getColony();
        Player owner = colony.getOwner();
        Unit student = colony.findStudent(teacher);
        if (student == null) {
            cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WARNING, "model.building.noStudent", colony, teacher).addStringTemplate("%teacher%", teacher.getLabel())).addName("%colony%", colony.getName()));
            return false;
        }
        teacher.setStudent(student);
        teacher.changeWorkType(null);
        student.setTeacher(teacher);
        cs.add(ChangeSet.See.only(owner), student);
        return true;
    }

    private void csRepairUnits(ChangeSet cs) {
        for (Unit unit : CollectionUtils.transform(this.getTile().getUnits(), u -> u.isDamaged() && this.getType().hasAbility("model.ability.repairUnits", u.getType()))) {
            ((ServerUnit)unit).csRepairUnit(cs);
        }
    }

    public void csCheckMissingInput(ProductionInfo pi, ChangeSet cs) {
        block5: {
            if (this.canAutoProduce()) {
                return;
            }
            List<AbstractGoods> production = pi.getProduction();
            if (production.isEmpty()) break block5;
            if (CollectionUtils.all(production, ag -> ag.getAmount() == 0)) {
                for (GoodsType gt : CollectionUtils.transform(this.getInputs(), ag -> ag.getAmount() > 0, AbstractGoods::getType)) {
                    cs.addMessage(this.getOwner(), (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "model.building.noInput", this, gt).addNamed("%inputGoods%", gt)).addNamed("%building%", this)).addName("%colony%", this.getColony().getName()));
                }
            } else {
                for (AbstractGoods ag2 : pi.getConsumptionDeficit()) {
                    cs.addMessage(this.getOwner(), (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "model.building.notEnoughInput", this, ag2.getType()).addNamed("%building%", this)).addName("%colony%", this.getColony().getName())).addAmount("%number%", ag2.getAmount())).addNamed("%goodsType%", ag2.getType()));
                }
            }
        }
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        BuildingType type = this.getType();
        if (this.canTeach()) {
            this.csTeach(cs);
        }
        if (type.hasAbility("model.ability.repairUnits")) {
            this.csRepairUnits(cs);
        }
    }
}

