/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208_Solaris;
import sun.nio.cs.ext.JIS_X_0212_Solaris;

public class EUC_JP_Open
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP_Open() {
        super("x-eucJP-Open", ExtendedCharsets.aliasesFor("x-eucJP-Open"));
    }

    @Override
    public String historicalName() {
        return "EUC_JP_Solaris";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof JIS_X_0201 || charset instanceof EUC_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends EUC_JP.Encoder {
        private static DoubleByte.Encoder ENC0208_Solaris = (DoubleByte.Encoder)new JIS_X_0208_Solaris().newEncoder();
        private static DoubleByte.Encoder ENC0212_Solaris = (DoubleByte.Encoder)new JIS_X_0212_Solaris().newEncoder();

        private Encoder(Charset charset) {
            super(charset);
        }

        @Override
        protected int encodeDouble(char c) {
            int n = super.encodeDouble(c);
            if (n != 65533) {
                return n;
            }
            n = ENC0208_Solaris.encodeChar(c);
            if (n != 65533 && n > 29952) {
                return 0x8F8080 + ENC0212_Solaris.encodeChar(c);
            }
            return n == 65533 ? n : n + 32896;
        }
    }

    private static class Decoder
    extends EUC_JP.Decoder {
        private static DoubleByte.Decoder DEC0208_Solaris = (DoubleByte.Decoder)new JIS_X_0208_Solaris().newDecoder();
        private static DoubleByte.Decoder DEC0212_Solaris = (DoubleByte.Decoder)new JIS_X_0212_Solaris().newDecoder();

        private Decoder(Charset charset) {
            super(charset, 0.5f, 1.0f, DEC0201, DEC0208, DEC0212_Solaris);
        }

        @Override
        protected char decodeDouble(int n, int n2) {
            char c = super.decodeDouble(n, n2);
            if (c == '\ufffd') {
                return DEC0208_Solaris.decodeDouble(n - 128, n2 - 128);
            }
            return c;
        }
    }
}

