/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import jakarta.servlet.ServletContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static ServletRequestContext currentServletRequestContext() {
        if (System.getSecurityManager() == null) {
            return ServletRequestContext.current();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServletRequestContext>(){

            @Override
            public ServletRequestContext run() {
                return ServletRequestContext.current();
            }
        });
    }

    static HttpSessionImpl forSession(final Session session, final ServletContext servletContext, final boolean newSession) {
        if (System.getSecurityManager() == null) {
            return HttpSessionImpl.forSession(session, servletContext, newSession);
        }
        return AccessController.doPrivileged(new PrivilegedAction<HttpSessionImpl>(){

            @Override
            public HttpSessionImpl run() {
                return HttpSessionImpl.forSession(session, servletContext, newSession);
            }
        });
    }

    static void setCurrentRequestContext(final ServletRequestContext servletRequestContext) {
        if (System.getSecurityManager() == null) {
            ServletRequestContext.setCurrentRequestContext(servletRequestContext);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ServletRequestContext.setCurrentRequestContext(servletRequestContext);
                    return null;
                }
            });
        }
    }

    static void clearCurrentServletAttachments() {
        if (System.getSecurityManager() == null) {
            ServletRequestContext.clearCurrentServletAttachments();
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ServletRequestContext.clearCurrentServletAttachments();
                    return null;
                }
            });
        }
    }

    static ServletRequestContext requireCurrentServletRequestContext() {
        if (System.getSecurityManager() == null) {
            return ServletRequestContext.requireCurrent();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServletRequestContext>(){

            @Override
            public ServletRequestContext run() {
                return ServletRequestContext.requireCurrent();
            }
        });
    }
}

