/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;

public final class ImportedProtoTypeMetadata
extends ProtoTypeMetadata {
    private final GenericDescriptor descriptor;
    private final BaseMarshaller<?> marshaller;

    public ImportedProtoTypeMetadata(GenericDescriptor descriptor, BaseMarshaller<?> marshaller, XClass javaClass) {
        super(descriptor.getFullName(), javaClass);
        this.descriptor = descriptor;
        this.marshaller = marshaller;
    }

    @Override
    public String getFullName() {
        return this.descriptor.getFullName();
    }

    @Override
    public boolean isImported() {
        return true;
    }

    @Override
    public String getFileName() {
        return this.descriptor.getFileDescriptor().getName();
    }

    @Override
    public boolean isEnum() {
        return this.descriptor instanceof EnumDescriptor;
    }

    @Override
    public ProtoEnumValueMetadata getEnumMemberByName(String name) {
        if (!this.isEnum()) {
            throw new IllegalStateException(this.getFullName() + " is not an enum");
        }
        EnumValueDescriptor evd = ((EnumDescriptor)this.descriptor).findValueByName(name);
        if (evd == null) {
            return null;
        }
        Object enumConstant = ((EnumMarshaller)this.marshaller).decode(evd.getNumber());
        return new ProtoEnumValueMetadata(evd.getNumber(), name, ((Enum)enumConstant).ordinal(), ((Enum)enumConstant).getDeclaringClass().getCanonicalName() + "." + ((Enum)enumConstant).name(), null);
    }

    @Override
    public ProtoEnumValueMetadata getEnumMemberByNumber(int number) {
        if (!this.isEnum()) {
            throw new IllegalStateException(this.getFullName() + " is not an enum");
        }
        Object enumConstant = ((EnumMarshaller)this.marshaller).decode(number);
        return new ProtoEnumValueMetadata(number, this.name, ((Enum)enumConstant).ordinal(), ((Enum)enumConstant).getDeclaringClass().getCanonicalName() + "." + ((Enum)enumConstant).name(), null);
    }

    public String toString() {
        return "ImportedProtoTypeMetadata{name='" + this.name + "', javaClass=" + String.valueOf(this.javaClass) + ", descriptor=" + String.valueOf(this.descriptor) + ", marshaller=" + String.valueOf(this.marshaller.getClass()) + "}";
    }
}

