/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.beanvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.beanvalidation.GroupsPerOperation;
import org.hibernate.boot.beanvalidation.HibernateTraversableResolver;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.PreCollectionUpdateEvent;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.PreUpsertEvent;
import org.hibernate.event.spi.PreUpsertEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class BeanValidationEventListener
implements PreInsertEventListener,
PreUpdateEventListener,
PreDeleteEventListener,
PreUpsertEventListener,
PreCollectionUpdateEventListener,
SessionFactoryObserver {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)BeanValidationEventListener.class.getName());
    private HibernateTraversableResolver traversableResolver = new HibernateTraversableResolver();
    private Validator validator;
    private GroupsPerOperation groupsPerOperation;

    public BeanValidationEventListener(ValidatorFactory factory, Map<String, Object> settings, ClassLoaderService classLoaderService) {
        this.validator = factory.usingContext().traversableResolver((TraversableResolver)this.traversableResolver).getValidator();
        this.groupsPerOperation = GroupsPerOperation.from(settings, new ClassLoaderAccessImpl(classLoaderService));
    }

    @Override
    public void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor implementor = (SessionFactoryImplementor)factory.unwrap(SessionFactoryImplementor.class);
        implementor.getMappingMetamodel().forEachEntityDescriptor(entityPersister -> this.traversableResolver.addPersister((EntityPersister)entityPersister, implementor));
    }

    @Override
    public boolean onPreInsert(PreInsertEvent event) {
        this.validate(event.getEntity(), event.getPersister(), event.getFactory(), GroupsPerOperation.Operation.INSERT);
        return false;
    }

    @Override
    public boolean onPreUpdate(PreUpdateEvent event) {
        this.validate(event.getEntity(), event.getPersister(), event.getFactory(), GroupsPerOperation.Operation.UPDATE);
        return false;
    }

    @Override
    public boolean onPreDelete(PreDeleteEvent event) {
        this.validate(event.getEntity(), event.getPersister(), event.getFactory(), GroupsPerOperation.Operation.DELETE);
        return false;
    }

    @Override
    public boolean onPreUpsert(PreUpsertEvent event) {
        this.validate(event.getEntity(), event.getPersister(), event.getFactory(), GroupsPerOperation.Operation.UPSERT);
        return false;
    }

    @Override
    public void onPreUpdateCollection(PreCollectionUpdateEvent event) {
        Object entity = NullnessUtil.castNonNull(event.getCollection().getOwner());
        this.validate(entity, event.getSession().getEntityPersister(event.getAffectedOwnerEntityName(), entity), event.getFactory(), GroupsPerOperation.Operation.UPDATE);
    }

    private <T> void validate(T object, EntityPersister persister, SessionFactoryImplementor sessionFactory, GroupsPerOperation.Operation operation) {
        Set constraintViolations;
        if (object == null || persister.getRepresentationStrategy().getMode() != RepresentationMode.POJO) {
            return;
        }
        Class[] groups = this.groupsPerOperation.get(operation);
        if (groups.length > 0 && !(constraintViolations = this.validator.validate(object, groups)).isEmpty()) {
            HashSet propagatedViolations = CollectionHelper.setOfSize(constraintViolations.size());
            HashSet<String> classNames = new HashSet<String>();
            for (ConstraintViolation violation : constraintViolations) {
                LOG.trace(violation);
                propagatedViolations.add(violation);
                classNames.add(violation.getLeafBean().getClass().getName());
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Validation failed for classes ");
            builder.append(classNames);
            builder.append(" during ");
            builder.append(operation.getName());
            builder.append(" time for groups ");
            builder.append(this.toString(groups));
            builder.append("\nList of constraint violations:[\n");
            for (ConstraintViolation violation : constraintViolations) {
                builder.append("\t").append(violation.toString()).append("\n");
            }
            builder.append("]");
            throw new ConstraintViolationException(builder.toString(), propagatedViolations);
        }
    }

    private String toString(Class<?>[] groups) {
        StringBuilder toString = new StringBuilder("[");
        for (Class<?> group : groups) {
            toString.append(group.getName()).append(", ");
        }
        toString.append("]");
        return toString.toString();
    }
}

