/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.AgroalDataSourceListener;
import java.sql.Connection;
import org.jboss.logging.Logger;

final class AgroalEventLoggingListener
implements AgroalDataSourceListener {
    private static final Logger log = Logger.getLogger((String)"io.agroal.pool");
    private static final String CONN_WITHOUT_TX = "Connection acquired without transaction.";
    private final String datasourceName;
    private final boolean transactionRequirementWarningActive;

    public AgroalEventLoggingListener(String name, boolean transactionRequirementWarningActive) {
        this.datasourceName = "Datasource '" + name + "'";
        this.transactionRequirementWarningActive = transactionRequirementWarningActive;
    }

    public void beforeConnectionLeak(Connection connection) {
        log.tracev("{0}: Leak test on connection {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void beforeConnectionReap(Connection connection) {
        log.tracev("{0}: Reap test on connection {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void beforeConnectionValidation(Connection connection) {
        log.tracev("{0}: Validation test on connection {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void onConnectionAcquire(Connection connection) {
        log.tracev("{0}: Acquire connection {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void onConnectionCreation(Connection connection) {
        log.tracev("{0}: Created connection {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void onConnectionLeak(Connection connection, Thread thread) {
        log.infov("{0}: Connection leak of {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void onConnectionReap(Connection connection) {
        log.tracev("{0}: Closing idle connection {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void onConnectionReturn(Connection connection) {
        log.tracev("{0}: Returning connection {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void onConnectionDestroy(Connection connection) {
        log.tracev("{0}: Destroyed connection {1}", (Object)this.datasourceName, (Object)connection);
    }

    public void onWarning(String warning) {
        if (warning != null && warning.contains("JDBC resources leaked")) {
            log.debugv("{0}: {1}", (Object)this.datasourceName, (Object)warning);
        } else {
            log.warnv("{0}: {1}", (Object)this.datasourceName, (Object)warning);
        }
    }

    public void onInfo(String message) {
        log.infov("{0}: {1}", (Object)this.datasourceName, (Object)message);
    }

    public void onWarning(Throwable throwable) {
        if (this.transactionRequirementWarningActive && CONN_WITHOUT_TX.equals(throwable.getMessage())) {
            log.warnv(throwable, "{0}", (Object)this.datasourceName);
        } else {
            log.warnv("{0}: {1}", (Object)this.datasourceName, (Object)throwable.getMessage());
            log.debug((Object)"Cause: ", throwable);
        }
    }
}

