/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Martinique
* Equirectangular projection

* @author CCM Benchmark Group
* @source http://commons.wikimedia.org/wiki/File:Martinique_department_location_map.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_02 : {
					width : 45.797703,
					height : 49.652901,
					getCoords : function (lat, lon) {
						var xfactor = 108.86848400636;
						var xoffset = 6666.0374751106;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -102.17420080747;
						var yoffset = 1520.2920010424;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-972" : "m 39.34,49.59 c -0.16,-0.06 -0.15,-0.08 0.02,-0.27 0.11,-0.12 0.21,-0.17 0.25,-0.11 0.19,0.28 0.51,-0.24 0.36,-0.59 -0.08,-0.2 -0.13,-0.22 -0.39,-0.15 -0.17,0.05 -0.34,0.04 -0.39,-0.01 -0.05,-0.05 -0.18,-0.06 -0.27,-0.02 -0.14,0.05 -0.17,0.13 -0.12,0.37 l 0.06,0.31 -0.25,-0.18 c -0.14,-0.1 -0.38,-0.21 -0.54,-0.24 -0.22,-0.04 -0.28,-0.1 -0.24,-0.24 0.04,-0.12 6e-5,-0.18 -0.11,-0.18 -0.19,0 -0.22,-0.15 -0.05,-0.2 0.2,-0.06 -0.01,-0.43 -0.32,-0.58 -0.43,-0.2 -0.43,-0.27 -0.07,-0.61 0.37,-0.36 1.09,-1.54 1.09,-1.8 0,-0.1 -0.09,-0.28 -0.2,-0.41 -0.11,-0.13 -0.2,-0.35 -0.2,-0.49 l 0,-0.26 0.29,0.25 c 0.26,0.23 0.32,0.24 0.53,0.13 0.32,-0.16 0.41,-0.29 0.26,-0.37 -0.09,-0.05 -0.09,-0.09 -0,-0.17 0.06,-0.06 0.1,-0.16 0.07,-0.22 -0.04,-0.09 0.05,-0.09 0.41,-0.02 0.5,0.1 0.72,0.03 0.44,-0.16 -0.24,-0.16 -0.22,-0.28 0.08,-0.4 0.25,-0.1 0.35,-0.29 0.15,-0.29 -0.06,0 -0.1,-0.07 -0.1,-0.15 0,-0.11 -0.07,-0.13 -0.29,-0.09 -0.27,0.05 -0.29,0.04 -0.24,-0.18 0.04,-0.19 0.01,-0.23 -0.15,-0.23 -0.11,0 -0.25,0.1 -0.31,0.23 -0.06,0.13 -0.16,0.23 -0.22,0.23 -0.06,0 -0.03,-0.1 0.06,-0.23 0.09,-0.12 0.13,-0.27 0.1,-0.32 -0.11,-0.16 -0.33,-0.11 -0.39,0.09 -0.03,0.1 -0.17,0.22 -0.32,0.27 -0.38,0.13 -1.37,1.07 -1.37,1.29 0,0.11 -0.12,0.25 -0.3,0.34 -0.17,0.09 -0.3,0.19 -0.3,0.23 -3e-4,0.04 -0.05,0.07 -0.1,0.07 -0.06,0 -0.1,-0.09 -0.1,-0.21 0,-0.12 -0.1,-0.27 -0.24,-0.34 -0.13,-0.07 -0.42,-0.28 -0.63,-0.46 -0.34,-0.28 -0.39,-0.37 -0.39,-0.73 l 0,-0.41 -0.35,0.03 c -0.19,0.02 -0.4,0.07 -0.47,0.11 -0.06,0.05 -0.13,0.06 -0.16,0.04 -0.03,-0.03 -0.38,0.08 -0.78,0.23 -0.67,0.26 -0.74,0.27 -0.89,0.13 -0.1,-0.09 -0.25,-0.13 -0.39,-0.1 -0.13,0.03 -0.25,0.01 -0.27,-0.04 -0.05,-0.15 -1.13,-0.22 -1.39,-0.09 -0.2,0.1 -0.23,0.09 -0.28,-0.08 -0.03,-0.1 -0.1,-0.16 -0.15,-0.13 -0.05,0.03 -0.25,-0.08 -0.43,-0.24 -0.25,-0.22 -0.39,-0.28 -0.55,-0.23 -0.12,0.03 -0.21,0.1 -0.21,0.14 0,0.04 -0.13,0.14 -0.29,0.21 -0.26,0.12 -0.32,0.11 -0.51,-0.02 -0.2,-0.14 -0.21,-0.17 -0.06,-0.27 0.22,-0.16 0.2,-0.38 -0.04,-0.44 -0.11,-0.03 -0.17,-0.1 -0.15,-0.16 0.06,-0.15 -0.22,-0.36 -0.41,-0.3 -0.08,0.03 -0.18,0.2 -0.22,0.38 -0.08,0.39 -0.24,0.51 -0.32,0.25 -0.05,-0.19 -0.4,-0.35 -0.51,-0.25 -0.03,0.03 -0.01,0.1 0.06,0.16 0.14,0.13 0.16,0.86 0.03,0.94 -0.05,0.03 -0.12,-0.01 -0.15,-0.09 -0.03,-0.08 -0.16,-0.14 -0.3,-0.14 -0.27,0 -0.66,-0.23 -0.56,-0.33 0.08,-0.08 -0.29,-0.78 -0.42,-0.78 -0.13,0 -0.29,0.21 -0.37,0.48 l -0.07,0.25 -0.37,-0.25 c -0.2,-0.14 -0.43,-0.33 -0.51,-0.42 -0.2,-0.24 -0.98,-0.16 -2,0.23 -0.95,0.36 -1.39,0.74 -1.41,1.23 -0.02,0.46 -0.19,0.71 -0.66,0.94 -0.33,0.16 -0.46,0.18 -0.68,0.11 -0.44,-0.15 -0.83,-0.54 -0.83,-0.84 0,-0.16 -0.1,-0.35 -0.25,-0.49 -0.28,-0.25 -0.38,-0.27 -0.68,-0.12 -0.24,0.12 -0.73,-0.06 -0.65,-0.24 0.03,-0.06 3e-5,-0.15 -0.06,-0.2 -0.11,-0.1 0.05,-0.48 0.2,-0.48 0.04,0 0.08,-0.27 0.09,-0.59 0.01,-0.64 -0.15,-0.89 -0.54,-0.86 -0.46,0.04 -0.55,-0.01 -0.55,-0.29 0,-0.26 0.08,-0.32 0.37,-0.28 0.19,0.02 0.27,-0.35 0.13,-0.63 -0.16,-0.34 -0.6,-0.51 -1,-0.39 -0.17,0.05 -0.39,0.07 -0.51,0.05 l -0.21,-0.05 0.2,-0.36 c 0.11,-0.2 0.18,-0.43 0.15,-0.52 -0.03,-0.09 0.01,-0.24 0.09,-0.34 0.08,-0.1 0.15,-0.25 0.15,-0.34 0,-0.1 0.16,-0.22 0.41,-0.32 0.38,-0.15 0.4,-0.18 0.35,-0.45 -0.06,-0.27 -0.03,-0.3 0.39,-0.49 0.25,-0.11 0.51,-0.31 0.57,-0.43 0.09,-0.18 0.17,-0.22 0.39,-0.18 1.05,0.19 1.01,0.2 1.23,-0.19 0.11,-0.19 0.26,-0.47 0.32,-0.61 0.09,-0.2 0.17,-0.25 0.42,-0.23 0.22,0.02 0.35,-0.04 0.46,-0.18 0.14,-0.19 0.14,-0.21 -0.09,-0.29 -0.21,-0.07 -0.22,-0.09 -0.06,-0.15 0.1,-0.04 0.18,-0.15 0.18,-0.26 0,-0.15 0.02,-0.17 0.09,-0.07 0.05,0.07 0.14,0.1 0.2,0.06 0.16,-0.09 0.14,0.15 -0.04,0.46 -0.08,0.14 -0.11,0.3 -0.06,0.34 0.13,0.12 0.86,-0.09 1.07,-0.3 0.27,-0.27 0.35,-0.23 0.35,0.19 0,0.34 -0.03,0.37 -0.31,0.43 -0.3,0.05 -0.31,0.07 -0.24,0.39 0.04,0.18 0.08,0.34 0.08,0.34 0.09,0.06 0.88,0.09 0.88,0.04 0,-0.04 0.09,-0.05 0.2,-0.03 0.15,0.04 0.19,0.1 0.14,0.25 -0.05,0.18 -0.01,0.22 0.28,0.27 0.25,0.05 0.37,0.02 0.46,-0.09 0.07,-0.09 0.24,-0.17 0.39,-0.18 0.2,-0.02 0.28,0.03 0.35,0.2 0.09,0.21 0.5,0.33 0.5,0.15 0,-0.04 0.14,-0.22 0.3,-0.39 0.3,-0.31 0.31,-0.31 0.46,-0.13 0.16,0.18 0.16,0.18 0.44,-0.1 0.15,-0.15 0.42,-0.33 0.6,-0.4 0.37,-0.14 0.43,-0.37 0.11,-0.44 -0.16,-0.04 -0.18,-0.07 -0.08,-0.13 0.07,-0.04 0.24,-0.08 0.36,-0.08 0.31,-0 0.29,-0.26 -0.02,-0.33 -0.2,-0.05 -0.24,-0.1 -0.2,-0.26 0.08,-0.29 -0.16,-0.45 -0.5,-0.33 -0.15,0.05 -0.27,0.06 -0.27,0.01 0,-0.13 -0.52,-0.21 -0.64,-0.1 -0.19,0.18 -0.27,0.1 -0.27,-0.27 0,-0.24 -0.05,-0.39 -0.15,-0.42 -0.21,-0.07 -0.19,-0.24 0.05,-0.52 0.11,-0.13 0.2,-0.3 0.2,-0.38 0,-0.08 -0.08,-0.15 -0.2,-0.15 -0.11,0 -0.2,-0.04 -0.2,-0.09 0,-0.21 -0.42,-0.46 -0.76,-0.46 -0.35,0 -0.35,-0 -0.35,-0.41 0,-0.34 0.03,-0.41 0.19,-0.41 0.25,0 0.55,-0.31 0.5,-0.52 -0.02,-0.12 -0.16,-0.18 -0.44,-0.22 l -0.4,-0.05 0.29,-0.11 c 0.22,-0.08 0.26,-0.14 0.18,-0.23 -0.06,-0.06 -0.12,-0.3 -0.14,-0.53 -0.04,-0.52 -0.27,-0.58 -0.67,-0.18 -0.24,0.24 -0.39,0.3 -0.82,0.34 -0.6,0.05 -0.66,0.1 -0.54,0.4 0.05,0.12 0.12,0.33 0.15,0.46 0.06,0.24 0.05,0.25 -0.37,0.28 -0.33,0.02 -0.45,0.08 -0.53,0.23 -0.06,0.11 -0.16,0.21 -0.23,0.21 -0.16,0 -0.16,-0.14 -0.02,-0.37 0.09,-0.15 0.06,-0.19 -0.16,-0.27 -0.36,-0.12 -0.37,-0.12 -0.68,0.14 -0.24,0.2 -0.28,0.21 -0.37,0.08 -0.05,-0.08 -0.07,-0.22 -0.05,-0.31 0.03,-0.1 -0.03,-0.2 -0.17,-0.27 -0.25,-0.12 -0.45,-0.04 -0.37,0.14 0.03,0.07 0.01,0.13 -0.04,0.13 -0.05,0 -0.1,-0.06 -0.1,-0.14 0,-0.19 -0.27,-0.27 -0.46,-0.13 -0.09,0.06 -0.15,0.07 -0.15,0.02 0,-0.16 -0.39,-0.19 -0.87,-0.06 -0.25,0.07 -0.62,0.12 -0.81,0.11 -0.3,-0.01 -0.4,-0.08 -0.68,-0.43 -0.18,-0.23 -0.41,-0.58 -0.52,-0.76 -0.11,-0.19 -0.27,-0.37 -0.37,-0.39 -0.1,-0.03 -0.21,-0.16 -0.24,-0.28 -0.04,-0.13 -0.22,-0.31 -0.42,-0.42 -0.19,-0.1 -0.35,-0.22 -0.35,-0.27 0,-0.11 -1.09,-0.57 -1.19,-0.51 -0.05,0.03 -0.28,-0.05 -0.52,-0.18 -0.24,-0.12 -0.56,-0.22 -0.72,-0.22 -0.32,0 -0.61,-0.32 -0.61,-0.67 0,-0.24 -0.62,-0.7 -0.94,-0.7 -0.09,0 -0.17,-0.04 -0.17,-0.09 0,-0.05 -0.09,-0.09 -0.2,-0.09 -0.15,0 -0.2,-0.07 -0.23,-0.34 -0.02,-0.27 -0.09,-0.37 -0.31,-0.46 -0.25,-0.11 -0.34,-0.27 -0.29,-0.51 0.01,-0.04 -0.07,-0.17 -0.18,-0.28 -0.11,-0.11 -0.23,-0.31 -0.27,-0.44 -0.04,-0.14 -0.17,-0.34 -0.3,-0.46 -0.4,-0.37 -1.68,-2.2 -1.68,-2.4 0,-0.11 -0.06,-0.28 -0.14,-0.38 -0.26,-0.34 -0.41,-1.1 -0.28,-1.39 0.06,-0.14 0.16,-0.45 0.21,-0.67 0.17,-0.76 0.34,-1.24 0.48,-1.38 0.08,-0.09 0.14,-0.36 0.14,-0.69 -10e-4,-0.44 -0.06,-0.62 -0.3,-0.97 -0.35,-0.5 -1.41,-1.54 -1.58,-1.54 -0.18,0 -0.49,-0.36 -0.9,-1.03 -0.21,-0.34 -0.45,-0.63 -0.55,-0.66 -0.09,-0.02 -0.32,-0.07 -0.5,-0.1 -0.28,-0.05 -0.39,-0.16 -0.73,-0.73 -0.22,-0.37 -0.41,-0.73 -0.41,-0.8 0,-0.07 -0.14,-0.25 -0.3,-0.39 -0.22,-0.19 -0.29,-0.32 -0.24,-0.47 0.03,-0.11 0.01,-0.28 -0.04,-0.38 -0.21,-0.35 -0.24,-1.23 -0.06,-1.76 0.22,-0.67 0.54,-1.28 0.77,-1.49 0.1,-0.09 0.19,-0.27 0.19,-0.4 0,-0.16 0.08,-0.26 0.25,-0.34 0.14,-0.06 0.25,-0.16 0.25,-0.24 0,-0.07 0.19,-0.38 0.42,-0.67 0.3,-0.38 0.49,-0.54 0.64,-0.54 0.34,0 0.89,-0.2 1.08,-0.38 0.09,-0.09 0.28,-0.17 0.43,-0.17 0.14,0 0.3,-0.06 0.34,-0.13 0.04,-0.07 0.22,-0.14 0.38,-0.16 0.25,-0.03 0.31,-0.08 0.34,-0.29 0.03,-0.2 0.07,-0.25 0.2,-0.19 0.26,0.1 0.53,0.08 1.03,-0.1 0.74,-0.26 3.4,-0.31 3.66,-0.07 0.07,0.06 0.34,0.11 0.6,0.11 0.3,0 0.52,0.05 0.6,0.14 0.07,0.08 0.19,0.14 0.26,0.14 0.07,0 0.18,0.07 0.23,0.15 0.07,0.11 0.18,0.14 0.44,0.1 0.25,-0.04 0.41,-0 0.58,0.12 0.13,0.1 0.32,0.17 0.41,0.17 0.09,0 0.27,0.08 0.39,0.18 0.12,0.1 0.33,0.18 0.48,0.18 0.18,0 0.29,0.07 0.35,0.21 0.1,0.25 0.67,0.79 0.85,0.81 0.07,0.01 0.16,0.02 0.22,0.04 0.06,0.01 0.18,0.03 0.29,0.03 0.1,0.01 0.35,0.18 0.55,0.38 0.2,0.2 0.44,0.37 0.54,0.37 0.1,0 0.23,0.06 0.3,0.14 0.07,0.08 0.28,0.14 0.48,0.14 0.3,0 0.37,0.04 0.47,0.28 0.06,0.15 0.17,0.28 0.24,0.28 0.07,0 0.13,0.04 0.13,0.09 0,0.05 0.07,0.09 0.15,0.09 0.08,0 0.15,0.03 0.15,0.07 0,0.04 0.19,0.12 0.42,0.19 0.39,0.11 0.44,0.1 0.8,-0.11 l 0.39,-0.23 0.32,0.36 c 0.3,0.35 0.33,0.36 0.77,0.31 0.49,-0.06 0.58,0.05 0.29,0.35 -0.25,0.25 -0.11,0.46 0.31,0.43 0.51,-0.03 0.77,0.21 0.77,0.72 0,0.44 0.21,0.7 0.68,0.86 0.26,0.09 0.64,0.04 0.64,-0.08 0,-0.04 0.18,-0.07 0.41,-0.07 0.39,-0.01 0.52,0.08 0.3,0.2 -0.06,0.03 -0.1,0.14 -0.1,0.23 0,0.1 -0.05,0.18 -0.1,0.18 -0.24,0 -0.09,0.48 0.23,0.74 0.2,0.16 0.34,0.37 0.35,0.52 0.02,0.25 0.35,0.57 0.59,0.57 0.07,0 0.16,0.08 0.2,0.18 0.03,0.1 0.15,0.28 0.27,0.41 0.18,0.21 0.26,0.23 0.6,0.18 0.27,-0.04 0.4,-0.02 0.4,0.05 0,0.06 -0.07,0.1 -0.15,0.1 -0.24,0 -0.17,0.29 0.15,0.63 0.19,0.2 0.35,0.29 0.45,0.25 0.13,-0.04 0.15,-0.01 0.1,0.17 -0.05,0.18 -0.01,0.24 0.18,0.31 0.46,0.16 0.72,0.47 0.65,0.76 -0.06,0.27 0.16,0.81 0.33,0.81 0.05,0 0.11,0.21 0.15,0.48 0.06,0.49 0.14,0.59 0.55,0.68 0.35,0.09 0.6,-0.18 0.65,-0.71 0.04,-0.38 0.12,-0.52 0.47,-0.84 0.23,-0.21 0.42,-0.42 0.42,-0.46 0,-0.04 0.09,-0.07 0.2,-0.07 0.2,0 0.72,-0.18 0.82,-0.28 0.25,-0.28 1.08,-0.34 1.17,-0.08 0.08,0.23 0.43,0.31 0.64,0.14 0.09,-0.08 0.3,-0.18 0.45,-0.24 0.15,-0.05 0.32,-0.2 0.38,-0.33 0.08,-0.18 0.15,-0.22 0.3,-0.18 0.29,0.08 0.81,-0.04 0.81,-0.19 0,-0.07 0.08,-0.13 0.17,-0.13 0.25,0 0.79,-0.41 1.05,-0.78 0.24,-0.35 0.47,-0.38 0.43,-0.05 -0.02,0.16 0.01,0.18 0.14,0.12 0.19,-0.1 0.65,-0.04 0.65,0.08 0,0.04 0.07,0.08 0.15,0.08 0.08,0 0.15,0.06 0.15,0.13 0,0.07 0.07,0.14 0.15,0.16 0.13,0.03 0.13,0.07 -0.01,0.33 -0.17,0.31 -0.17,0.29 0.15,0.86 0.02,0.03 -0.09,0.08 -0.25,0.09 -0.34,0.04 -0.64,-0.25 -0.64,-0.61 0,-0.28 -0.24,-0.4 -0.45,-0.24 -0.08,0.06 -0.2,0.08 -0.26,0.05 -0.2,-0.11 -0.61,0.04 -0.61,0.22 0,0.1 -0.09,0.19 -0.21,0.22 -0.32,0.08 -0.22,0.45 0.18,0.61 0.6,0.26 0.68,0.73 0.13,0.73 -0.19,0 -0.36,0.08 -0.5,0.25 -0.31,0.36 -0.24,0.45 0.57,0.63 0.07,0.02 0.09,0.11 0.06,0.22 -0.04,0.14 -0.11,0.18 -0.25,0.15 -0.11,-0.03 -0.22,0.01 -0.25,0.08 -0.07,0.17 -0.43,0.17 -0.65,-0.01 -0.16,-0.13 -0.2,-0.13 -0.49,0 -0.4,0.19 -0.51,0.12 -0.51,-0.3 -8.1e-4,-0.19 -0.04,-0.38 -0.08,-0.44 -0.09,-0.12 -0.73,-0.43 -0.73,-0.35 0,0.03 -0.16,-0.04 -0.36,-0.15 -0.28,-0.16 -0.46,-0.19 -0.78,-0.15 -0.23,0.03 -0.49,0.02 -0.58,-0.03 -0.21,-0.1 -0.31,-0.03 -0.54,0.38 -0.12,0.21 -0.24,0.32 -0.32,0.29 -0.17,-0.06 -0.29,0.34 -0.2,0.66 0.04,0.15 0.17,0.25 0.39,0.31 l 0.33,0.09 -0.35,0.01 c -0.28,0.01 -0.38,0.06 -0.48,0.26 -0.24,0.47 -0.1,0.81 0.41,0.97 0.1,0.03 0.18,0.12 0.18,0.19 0,0.14 0.37,0.42 0.56,0.42 0.06,0 0.19,-0.14 0.28,-0.32 0.12,-0.22 0.22,-0.3 0.33,-0.26 0.12,0.04 0.13,0.08 0.04,0.18 -0.06,0.07 -0.08,0.17 -0.04,0.23 0.04,0.06 -0.08,0.22 -0.27,0.36 -0.28,0.22 -0.32,0.29 -0.23,0.43 0.15,0.22 0.47,0.26 1.03,0.12 0.3,-0.08 0.51,-0.2 0.62,-0.36 0.23,-0.34 0.44,-0.26 0.36,0.15 -0.05,0.22 -0.03,0.31 0.06,0.31 0.1,0 0.1,0.03 -0,0.14 -0.11,0.12 -0.08,0.19 0.16,0.41 0.3,0.28 0.63,0.34 0.97,0.18 0.15,-0.07 0.2,-0.07 0.2,0.05 0,0.08 0.04,0.14 0.09,0.14 0.05,0 0.07,0.08 0.04,0.18 -0.04,0.14 -0.11,0.17 -0.34,0.13 -0.25,-0.05 -0.3,-0.02 -0.43,0.27 -0.16,0.36 -0.37,0.52 -0.37,0.3 0,-0.21 -0.67,-0.19 -0.82,0.02 -0.08,0.12 -0.2,0.15 -0.41,0.13 -0.19,-0.03 -0.37,0.02 -0.49,0.12 -0.24,0.2 -0.25,0.39 -0.03,0.61 0.15,0.15 0.15,0.17 -0.02,0.23 -0.12,0.04 -0.24,6.6e-4 -0.35,-0.12 -0.09,-0.1 -0.27,-0.22 -0.39,-0.25 -0.18,-0.05 -0.23,-0.02 -0.28,0.19 -0.12,0.55 -0.21,0.72 -0.43,0.81 -0.27,0.11 -0.31,0.49 -0.05,0.57 0.1,0.03 0.21,0.11 0.26,0.18 0.04,0.07 0.15,0.12 0.23,0.12 0.08,0 0.22,0.15 0.31,0.34 0.44,0.97 1.2,1.02 1.83,0.14 0.37,-0.51 0.68,-0.65 0.84,-0.38 0.12,0.21 0.4,0.14 0.4,-0.11 0,-0.1 0.07,-0.17 0.15,-0.17 0.08,0 0.15,0.06 0.15,0.13 0,0.18 0.2,0.28 0.33,0.15 0.17,-0.16 0.36,-0.12 0.31,0.06 -0.03,0.11 0.05,0.2 0.23,0.28 0.42,0.17 0.55,0.15 0.49,-0.1 -0.08,-0.28 0.16,-0.45 0.58,-0.41 0.32,0.03 0.33,0.05 0.3,0.35 -0.02,0.18 -0.08,0.34 -0.13,0.35 -0.05,0.02 -0.09,0.15 -0.09,0.3 0,0.28 -0.17,0.36 -0.27,0.13 -0.03,-0.08 -0.1,-0.14 -0.16,-0.14 -0.06,0 -0.08,0.06 -0.04,0.14 0.09,0.22 -0.02,0.37 -0.31,0.39 -0.15,0.01 -0.32,0.06 -0.39,0.11 -0.08,0.06 -0.18,0.04 -0.3,-0.09 -0.22,-0.22 -0.5,-0.25 -0.42,-0.04 0.04,0.1 -0.01,0.16 -0.14,0.19 -0.33,0.08 -0.23,0.29 0.15,0.35 0.2,0.03 0.44,0.16 0.55,0.28 0.1,0.12 0.23,0.22 0.28,0.22 0.05,0 0.07,0.14 0.05,0.32 -0.03,0.2 0,0.32 0.07,0.32 0.06,0 0.11,0.06 0.11,0.14 0,0.08 -0.07,0.14 -0.15,0.14 -0.08,0 -0.15,0.06 -0.15,0.14 0,0.08 -0.07,0.14 -0.15,0.14 -0.11,0 -0.14,0.06 -0.09,0.22 0.03,0.12 0.01,0.25 -0.05,0.28 -0.06,0.03 -0.11,0.14 -0.11,0.23 0,0.28 0.78,0.4 1.09,0.17 0.14,-0.11 0.24,0.05 0.2,0.33 -0.04,0.28 0.18,0.27 0.33,-0.01 0.08,-0.15 0.15,-0.21 0.18,-0.14 0.06,0.15 0.21,0.14 0.4,-0.02 0.17,-0.16 0.34,-0.18 0.34,-0.05 0,0.05 0.13,0.1 0.28,0.1 l 0.28,0.01 -0.28,0.11 c -0.15,0.06 -0.35,0.2 -0.44,0.32 -0.14,0.19 -0.14,0.22 0.08,0.46 0.13,0.14 0.36,0.3 0.51,0.36 0.3,0.11 0.39,0.45 0.14,0.54 -0.2,0.07 -0.27,0.38 -0.12,0.52 0.07,0.06 0.2,0.22 0.3,0.34 0.11,0.14 0.28,0.24 0.45,0.24 0.15,0.01 0.4,0.04 0.55,0.08 0.2,0.05 0.35,0.01 0.55,-0.13 l 0.28,-0.2 0.14,0.24 c 0.08,0.13 0.12,0.26 0.08,0.29 -0.03,0.03 -0.01,0.12 0.04,0.21 0.07,0.11 0.05,0.19 -0.05,0.27 -0.24,0.18 -0.17,0.34 0.18,0.41 l 0.33,0.07 -0.44,0.09 c -0.42,0.09 -0.44,0.11 -0.38,0.37 0.03,0.15 0.06,0.33 0.06,0.41 0,0.11 0.09,0.12 0.42,0.07 0.3,-0.05 0.4,-0.03 0.35,0.04 -0.04,0.06 -0.14,0.1 -0.22,0.1 -0.09,0 -0.14,0.06 -0.12,0.16 0.04,0.17 0.38,0.2 0.71,0.07 0.26,-0.1 0.23,0.19 -0.03,0.34 -0.28,0.16 -0.25,0.35 0.05,0.35 0.14,0 0.25,-0.04 0.25,-0.09 0,-0.05 0.19,-0.2 0.43,-0.34 0.24,-0.14 0.51,-0.34 0.6,-0.44 0.09,-0.1 0.2,-0.15 0.24,-0.12 0.04,0.04 0.01,0.14 -0.07,0.23 -0.08,0.09 -0.16,0.25 -0.16,0.36 -0.01,0.23 -0.32,0.58 -0.5,0.58 -0.13,0 -0.18,0.16 -0.15,0.48 0.01,0.09 -0.05,0.16 -0.14,0.16 -0.08,0 -0.15,0.02 -0.15,0.05 0,0.13 0.34,0.5 0.46,0.5 0.14,0 0.82,0.58 0.88,0.76 0.06,0.16 -0.14,0.32 -0.35,0.27 -0.27,-0.06 -0.69,0.06 -0.69,0.2 0,0.09 0.17,0.12 0.63,0.11 l 0.63,-0.01 -0.03,0.46 c -0.04,0.53 -0.14,0.68 -0.37,0.51 -0.09,-0.07 -0.26,-0.09 -0.42,-0.06 -0.22,0.05 -0.25,0.1 -0.2,0.29 0.04,0.14 0,0.31 -0.09,0.43 -0.19,0.25 -0.2,0.61 -0.01,0.67 0.08,0.03 0.27,-0.06 0.42,-0.19 0.59,-0.5 0.87,-0.24 0.8,0.77 -0.05,0.85 0.14,1.34 0.49,1.28 0.3,-0.05 0.48,0.12 0.48,0.46 0,0.15 0.09,0.38 0.21,0.51 0.23,0.27 0.2,0.46 -0.12,0.83 -0.25,0.28 -0.49,0.31 -0.49,0.05 0,-0.17 -0.3,-0.28 -0.31,-0.11 -8.2e-4,0.04 -0.03,0.16 -0.06,0.28 -0.05,0.15 -0.02,0.21 0.11,0.21 0.09,0 0.2,0.07 0.23,0.16 0.04,0.09 0.15,0.27 0.26,0.4 0.21,0.26 0.17,0.63 -0.07,0.63 -0.16,0 -0.46,0.3 -0.46,0.46 0,0.07 -0.07,0.17 -0.15,0.22 -0.12,0.08 -0.13,0.17 -0.06,0.4 0.06,0.18 0.06,0.32 5.8e-4,0.35 -0.05,0.03 -0.09,0.15 -0.09,0.27 0,0.32 -0.21,0.69 -0.4,0.69 -0.28,0.01 -0.64,0.34 -0.57,0.54 0.04,0.1 -0,0.24 -0.09,0.32 -0.09,0.08 -0.13,0.21 -0.09,0.29 0.03,0.08 0.02,0.15 -0.03,0.15 -0.05,7.4e-4 -0.19,0.03 -0.31,0.06 -0.16,0.04 -0.23,0.02 -0.23,-0.08 0,-0.19 -0.21,-0.33 -0.58,-0.4 -0.28,-0.05 -0.31,-0.03 -0.37,0.24 -0.07,0.33 0.14,0.61 0.4,0.52 0.13,-0.04 0.15,-0 0.09,0.21 -0.06,0.25 -0.04,0.27 0.3,0.33 0.22,0.04 0.36,0.11 0.36,0.2 0,0.21 -0.29,0.26 -0.5,0.09 -0.19,-0.16 -0.61,-0.13 -0.61,0.04 0,0.04 -0.16,0.23 -0.35,0.42 -0.19,0.19 -0.36,0.41 -0.37,0.49 -0.01,0.08 -0.02,0.23 -0.03,0.32 -0.01,0.2 -0.5,0.27 -0.78,0.11 -0.12,-0.07 -0.22,-0.04 -0.4,0.11 -0.25,0.21 -0.26,0.22 -0.52,0.12 z"
					}
				}
			}
		}
	);
})(jQuery);