/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.box;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSRectangleType;
import org.jfree.layouting.input.style.values.CSSRectangleValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class CropReadHandler
implements CSSValueReadHandler {
    @Override
    public CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 35) {
            String string = lexicalUnit.getStringValue();
            if ("auto".equalsIgnoreCase(string) || "none".equalsIgnoreCase(string)) {
                return CSSAutoValue.getInstance();
            }
        } else {
            if (lexicalUnit.getLexicalUnitType() == 41) {
                if ("inset-rect".equalsIgnoreCase(lexicalUnit.getFunctionName())) {
                    return CropReadHandler.getRectangle(CSSRectangleType.INSET_RECT, lexicalUnit.getParameters());
                }
                return null;
            }
            if (lexicalUnit.getLexicalUnitType() == 38) {
                return CropReadHandler.getRectangle(CSSRectangleType.RECT, lexicalUnit.getParameters());
            }
        }
        return null;
    }

    private static CSSRectangleValue getRectangle(CSSRectangleType cSSRectangleType, LexicalUnit lexicalUnit) {
        CSSNumericValue[] cSSNumericValueArray = new CSSNumericValue[4];
        for (int i = 0; i < 4; ++i) {
            if (lexicalUnit == null) {
                return null;
            }
            CSSNumericValue cSSNumericValue = CSSValueFactory.createLengthValue(lexicalUnit);
            if (cSSNumericValue != null) {
                cSSNumericValueArray[i] = cSSNumericValue;
            } else if (lexicalUnit.getLexicalUnitType() == 23) {
                cSSNumericValueArray[i] = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
            } else {
                return null;
            }
            lexicalUnit = CSSValueFactory.parseComma(lexicalUnit);
        }
        return new CSSRectangleValue(cSSRectangleType, cSSNumericValueArray[0], cSSNumericValueArray[1], cSSNumericValueArray[2], cSSNumericValueArray[3]);
    }
}

