/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.CSSCounterRule;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.selectors.CSSSelector;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.DocumentMetaNode;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.StyleRuleMatcher;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class SimpleStyleRuleMatcher
implements StyleRuleMatcher {
    private LayoutProcess layoutProcess;
    private ResourceManager resourceManager;
    private CSSStyleRule[] activeStyleRules;
    private CSSStyleRule[] activePseudoStyleRules;
    private CSSPageRule[] pageRules;
    private CSSCounterRule[] counterRules;
    private NamespaceCollection namespaces;

    @Override
    public void initialize(LayoutProcess layoutProcess) {
        int n;
        Object object;
        Object object2;
        int n2;
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.layoutProcess = layoutProcess;
        this.resourceManager = layoutProcess.getResourceManager();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        DocumentContext documentContext = this.layoutProcess.getDocumentContext();
        this.namespaces = documentContext.getNamespaces();
        String[] stringArray = this.namespaces.getNamespaces();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            ResourceKey resourceKey;
            StyleSheet styleSheet;
            String string = stringArray[n2];
            object2 = this.namespaces.getDefinition(string);
            object = object2.getDefaultStyleSheetLocation();
            if (object == null || (styleSheet = this.parseStyleSheet((ResourceKey)object, resourceKey = DocumentContextUtility.getBaseResource(layoutProcess.getDocumentContext()))) == null) continue;
            this.addStyleRules(styleSheet, arrayList3);
            this.addPageRules(styleSheet, arrayList);
            this.addCounterRules(styleSheet, arrayList2);
        }
        n2 = documentContext.getMetaNodeCount();
        for (n = 0; n < n2; ++n) {
            object2 = documentContext.getMetaNode(n);
            object = (String)object2.getMetaAttribute("type");
            if ("link".equals(object)) {
                this.handleLinkNode((DocumentMetaNode)object2, arrayList3, arrayList, arrayList2);
                continue;
            }
            if (!"style".equals(object)) continue;
            this.handleStyleNode((DocumentMetaNode)object2, arrayList3, arrayList, arrayList2);
        }
        this.activeStyleRules = arrayList3.toArray(new CSSStyleRule[arrayList3.size()]);
        this.pageRules = arrayList.toArray(new CSSPageRule[arrayList.size()]);
        this.counterRules = arrayList2.toArray(new CSSCounterRule[arrayList2.size()]);
        arrayList3.clear();
        for (n = 0; n < this.activeStyleRules.length; ++n) {
            object2 = this.activeStyleRules[n];
            if (!this.isPseudoElementRule((CSSStyleRule)object2)) continue;
            arrayList3.add(object2);
        }
        this.activePseudoStyleRules = arrayList3.toArray(new CSSStyleRule[arrayList3.size()]);
    }

    private void handleLinkNode(DocumentMetaNode documentMetaNode, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        try {
            Object object = documentMetaNode.getMetaAttribute("href");
            ResourceKey resourceKey = DocumentContextUtility.getBaseResource(this.layoutProcess.getDocumentContext());
            ResourceKey resourceKey2 = resourceKey == null ? this.resourceManager.createKey(object) : this.resourceManager.deriveKey(resourceKey, String.valueOf(object));
            StyleSheet styleSheet = this.parseStyleSheet(resourceKey2, null);
            if (styleSheet == null) {
                return;
            }
            this.addStyleRules(styleSheet, arrayList);
            this.addPageRules(styleSheet, arrayList2);
            this.addCounterRules(styleSheet, arrayList3);
        }
        catch (ResourceKeyCreationException resourceKeyCreationException) {
            resourceKeyCreationException.printStackTrace();
        }
    }

    private void handleStyleNode(DocumentMetaNode documentMetaNode, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        Object object;
        Object object2 = documentMetaNode.getMetaAttribute("#pcdata");
        if (object2 == null && (object = documentMetaNode.getMetaAttribute("#content")) instanceof StyleSheet) {
            StyleSheet styleSheet = (StyleSheet)object;
            this.addStyleRules(styleSheet, arrayList);
            this.addPageRules(styleSheet, arrayList2);
            this.addCounterRules(styleSheet, arrayList3);
            return;
        }
        object = String.valueOf(object2);
        try {
            byte[] byArray = ((String)object).getBytes("UTF-8");
            ResourceKey resourceKey = this.resourceManager.createKey((Object)byArray);
            ResourceKey resourceKey2 = DocumentContextUtility.getBaseResource(this.layoutProcess.getDocumentContext());
            StyleSheet styleSheet = this.parseStyleSheet(resourceKey, resourceKey2);
            if (styleSheet == null) {
                return;
            }
            this.addStyleRules(styleSheet, arrayList);
            this.addPageRules(styleSheet, arrayList2);
            this.addCounterRules(styleSheet, arrayList3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (ResourceKeyCreationException resourceKeyCreationException) {
            resourceKeyCreationException.printStackTrace();
        }
    }

    private void addCounterRules(StyleSheet styleSheet, ArrayList arrayList) {
        int n;
        int n2 = styleSheet.getStyleSheetCount();
        for (n = 0; n < n2; ++n) {
            this.addCounterRules(styleSheet.getStyleSheet(n), arrayList);
        }
        n = styleSheet.getRuleCount();
        for (int i = 0; i < n; ++i) {
            StyleRule styleRule = styleSheet.getRule(i);
            if (!(styleRule instanceof CSSCounterRule)) continue;
            CSSCounterRule cSSCounterRule = (CSSCounterRule)styleRule;
            arrayList.add(cSSCounterRule);
        }
    }

    private void addPageRules(StyleSheet styleSheet, ArrayList arrayList) {
        int n;
        int n2 = styleSheet.getStyleSheetCount();
        for (n = 0; n < n2; ++n) {
            this.addPageRules(styleSheet.getStyleSheet(n), arrayList);
        }
        n = styleSheet.getRuleCount();
        for (int i = 0; i < n; ++i) {
            StyleRule styleRule = styleSheet.getRule(i);
            if (!(styleRule instanceof CSSPageRule)) continue;
            CSSPageRule cSSPageRule = (CSSPageRule)styleRule;
            arrayList.add(cSSPageRule);
        }
    }

    private void addStyleRules(StyleSheet styleSheet, ArrayList arrayList) {
        int n;
        int n2 = styleSheet.getStyleSheetCount();
        for (n = 0; n < n2; ++n) {
            this.addStyleRules(styleSheet.getStyleSheet(n), arrayList);
        }
        n = styleSheet.getRuleCount();
        for (int i = 0; i < n; ++i) {
            StyleRule styleRule = styleSheet.getRule(i);
            if (!(styleRule instanceof CSSStyleRule)) continue;
            CSSStyleRule cSSStyleRule = (CSSStyleRule)styleRule;
            arrayList.add(cSSStyleRule);
        }
    }

    private StyleSheet parseStyleSheet(ResourceKey resourceKey, ResourceKey resourceKey2) {
        try {
            Resource resource = this.resourceManager.create(resourceKey, resourceKey2, StyleSheet.class);
            return (StyleSheet)resource.getResource();
        }
        catch (ResourceException resourceException) {
            DebugLog.log((Object)("Unable to parse StyleSheet: " + resourceException.getLocalizedMessage()));
            return null;
        }
    }

    private boolean isPseudoElementRule(CSSStyleRule cSSStyleRule) {
        CSSSelector cSSSelector = cSSStyleRule.getSelector();
        if (cSSSelector == null) {
            return false;
        }
        if (cSSSelector.getSelectorType() != 0) {
            return false;
        }
        ConditionalSelector conditionalSelector = (ConditionalSelector)cSSSelector;
        Condition condition = conditionalSelector.getCondition();
        return condition.getConditionType() == 10;
    }

    @Override
    public boolean isMatchingPseudoElement(LayoutElement layoutElement, String string) {
        for (int i = 0; i < this.activePseudoStyleRules.length; ++i) {
            SimpleSelector simpleSelector;
            CSSStyleRule cSSStyleRule = this.activePseudoStyleRules[i];
            CSSSelector cSSSelector = cSSStyleRule.getSelector();
            ConditionalSelector conditionalSelector = (ConditionalSelector)cSSSelector;
            Condition condition = conditionalSelector.getCondition();
            AttributeCondition attributeCondition = (AttributeCondition)condition;
            if (!ObjectUtilities.equal((Object)attributeCondition.getValue(), (Object)string) || !this.isMatch(layoutElement, (Selector)(simpleSelector = conditionalSelector.getSimpleSelector()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public StyleRuleMatcher deriveInstance() {
        return this;
    }

    @Override
    public CSSStyleRule[] getMatchingRules(LayoutElement layoutElement) {
        ArrayList<CSSStyleRule> arrayList = new ArrayList<CSSStyleRule>();
        for (int i = 0; i < this.activeStyleRules.length; ++i) {
            CSSStyleRule cSSStyleRule = this.activeStyleRules[i];
            CSSSelector cSSSelector = cSSStyleRule.getSelector();
            if (cSSSelector == null || !this.isMatch(layoutElement, cSSSelector)) continue;
            arrayList.add(cSSStyleRule);
        }
        return arrayList.toArray(new CSSStyleRule[arrayList.size()]);
    }

    private boolean isMatch(LayoutElement layoutElement, Selector selector) {
        short s = selector.getSelectorType();
        switch (s) {
            case 1: {
                return true;
            }
            case 2: {
                return layoutElement.getParent() == null;
            }
            case 3: {
                NegativeSelector negativeSelector = (NegativeSelector)selector;
                return !this.isMatch(layoutElement, (Selector)negativeSelector);
            }
            case 12: {
                SiblingSelector siblingSelector = (SiblingSelector)selector;
                return this.isSilblingMatch(layoutElement, siblingSelector);
            }
            case 9: {
                LayoutContext layoutContext = layoutElement.getLayoutContext();
                return layoutContext.isPseudoElement();
            }
            case 4: {
                ElementSelector elementSelector = (ElementSelector)selector;
                LayoutContext layoutContext = layoutElement.getLayoutContext();
                String string = elementSelector.getLocalName();
                if (string != null && !string.equals(layoutContext.getTagName())) {
                    return false;
                }
                String string2 = elementSelector.getNamespaceURI();
                return string2 == null || string2.equals(layoutContext.getNamespace());
            }
            case 11: {
                DescendantSelector descendantSelector = (DescendantSelector)selector;
                if (!this.isMatch(layoutElement, (Selector)descendantSelector.getSimpleSelector())) {
                    return false;
                }
                LayoutElement layoutElement2 = layoutElement.getParent();
                return this.isMatch(layoutElement2, descendantSelector.getAncestorSelector());
            }
            case 10: {
                DescendantSelector descendantSelector = (DescendantSelector)selector;
                if (!this.isMatch(layoutElement, (Selector)descendantSelector.getSimpleSelector())) {
                    return false;
                }
                return this.isDescendantMatch(layoutElement, descendantSelector.getAncestorSelector());
            }
            case 0: {
                ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                if (!this.evaluateCondition(layoutElement, conditionalSelector.getCondition())) {
                    return false;
                }
                return this.isMatch(layoutElement, (Selector)conditionalSelector.getSimpleSelector());
            }
        }
        return false;
    }

    private boolean evaluateCondition(LayoutElement layoutElement, Condition condition) {
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                return this.evaluateCondition(layoutElement, combinatorCondition.getFirstCondition()) && this.evaluateCondition(layoutElement, combinatorCondition.getSecondCondition());
            }
            case 1: {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                return this.evaluateCondition(layoutElement, combinatorCondition.getFirstCondition()) || this.evaluateCondition(layoutElement, combinatorCondition.getSecondCondition());
            }
            case 4: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                LayoutContext layoutContext = layoutElement.getLayoutContext();
                String string = attributeCondition.getNamespaceURI();
                if (string == null) {
                    string = layoutContext.getNamespace();
                }
                AttributeMap attributeMap = layoutContext.getAttributes();
                Object object = attributeMap.getAttribute(string, attributeCondition.getLocalName());
                if (attributeCondition.getValue() == null) {
                    return object != null;
                }
                return ObjectUtilities.equal((Object)object, (Object)attributeCondition.getValue());
            }
            case 9: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                LayoutContext layoutContext = layoutElement.getLayoutContext();
                String string = layoutContext.getNamespace();
                if (string == null) {
                    return false;
                }
                NamespaceDefinition namespaceDefinition = this.namespaces.getDefinition(string);
                if (namespaceDefinition == null) {
                    return false;
                }
                String[] stringArray = namespaceDefinition.getClassAttribute(layoutContext.getTagName());
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    String string3 = (String)layoutContext.getAttributes().getAttribute(string, string2);
                    if (!this.isOneOfAttributes(string3, attributeCondition.getValue())) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                LayoutContext layoutContext = layoutElement.getLayoutContext();
                AttributeMap attributeMap = layoutContext.getAttributes();
                Object object = attributeMap.getAttribute("http://www.w3.org/XML/1998/namespace", "id");
                return ObjectUtilities.equal((Object)attributeCondition.getValue(), (Object)object);
            }
            case 6: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                LayoutContext layoutContext = layoutElement.getLayoutContext();
                Locale locale = layoutContext.getLanguage();
                String string = locale.getLanguage();
                return this.isBeginHyphenAttribute(string, attributeCondition.getValue());
            }
            case 2: {
                NegativeCondition negativeCondition = (NegativeCondition)condition;
                return !this.evaluateCondition(layoutElement, negativeCondition.getCondition());
            }
            case 7: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                LayoutContext layoutContext = layoutElement.getLayoutContext();
                String string = (String)layoutContext.getAttributes().getAttribute(attributeCondition.getNamespaceURI(), attributeCondition.getLocalName());
                return this.isOneOfAttributes(string, attributeCondition.getValue());
            }
            case 10: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                LayoutContext layoutContext = layoutElement.getLayoutContext();
                String string = layoutContext.getPseudoElement();
                if (string == null) {
                    return false;
                }
                return string.equals(attributeCondition.getValue());
            }
        }
        return false;
    }

    private boolean isOneOfAttributes(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeginHyphenAttribute(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    private boolean isDescendantMatch(LayoutElement layoutElement, Selector selector) {
        for (LayoutElement layoutElement2 = layoutElement.getParent(); layoutElement2 != null; layoutElement2 = layoutElement2.getParent()) {
            if (!this.isMatch(layoutElement2, selector)) continue;
            return true;
        }
        return false;
    }

    private boolean isSilblingMatch(LayoutElement layoutElement, SiblingSelector siblingSelector) {
        for (LayoutElement layoutElement2 = layoutElement.getPrevious(); layoutElement2 != null; layoutElement2 = layoutElement2.getPrevious()) {
            if (!this.isMatch(layoutElement2, (Selector)siblingSelector)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CSSPageRule[] getPageRule(CSSValue cSSValue, PseudoPage[] pseudoPageArray) {
        CSSPageRule[] cSSPageRuleArray = this.pageRules;
        ArrayList<CSSPageRule> arrayList = new ArrayList<CSSPageRule>();
        for (int i = 0; i < cSSPageRuleArray.length; ++i) {
            CSSPageRule cSSPageRule = cSSPageRuleArray[i];
            String string = cSSPageRule.getName();
            if (string != null && !string.equals(cSSValue)) continue;
            String string2 = cSSPageRule.getPseudoPage();
            if (string2 != null) {
                for (int j = 0; j < pseudoPageArray.length; ++j) {
                    PseudoPage pseudoPage = pseudoPageArray[j];
                    if (!pseudoPage.toString().equalsIgnoreCase(string2)) continue;
                    arrayList.add(cSSPageRule);
                }
                continue;
            }
            arrayList.add(cSSPageRule);
        }
        return arrayList.toArray(new CSSPageRule[arrayList.size()]);
    }
}

