/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.text;

import org.jfree.layouting.input.style.keys.line.AlignmentBaseline;
import org.jfree.layouting.input.style.keys.line.DominantBaseline;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.text.DefaultExtendedBaselineInfo;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class TextUtility {
    private TextUtility() {
    }

    public static int translateDominantBaseline(CSSValue cSSValue, int n) {
        if (cSSValue == null || CSSAutoValue.getInstance().equals(cSSValue)) {
            return n;
        }
        if (DominantBaseline.ALPHABETIC.equals(cSSValue)) {
            return 6;
        }
        if (DominantBaseline.CENTRAL.equals(cSSValue)) {
            return 3;
        }
        if (DominantBaseline.HANGING.equals(cSSValue)) {
            return 2;
        }
        if (DominantBaseline.IDEOGRAPHIC.equals(cSSValue)) {
            return 7;
        }
        if (DominantBaseline.MATHEMATICAL.equals(cSSValue)) {
            return 5;
        }
        if (DominantBaseline.MIDDLE.equals(cSSValue)) {
            return 4;
        }
        if (DominantBaseline.TEXT_AFTER_EDGE.equals(cSSValue)) {
            return 8;
        }
        if (DominantBaseline.TEXT_BEFORE_EDGE.equals(cSSValue)) {
            return 1;
        }
        return n;
    }

    public static int translateAlignmentBaseline(CSSValue cSSValue, int n) {
        if (cSSValue == null || CSSAutoValue.getInstance().equals(cSSValue)) {
            return n;
        }
        if (AlignmentBaseline.ALPHABETIC.equals(cSSValue)) {
            return 6;
        }
        if (AlignmentBaseline.CENTRAL.equals(cSSValue)) {
            return 3;
        }
        if (AlignmentBaseline.HANGING.equals(cSSValue)) {
            return 2;
        }
        if (AlignmentBaseline.IDEOGRAPHIC.equals(cSSValue)) {
            return 7;
        }
        if (AlignmentBaseline.MATHEMATICAL.equals(cSSValue)) {
            return 5;
        }
        if (AlignmentBaseline.MIDDLE.equals(cSSValue)) {
            return 4;
        }
        if (AlignmentBaseline.TEXT_AFTER_EDGE.equals(cSSValue)) {
            return 8;
        }
        if (AlignmentBaseline.TEXT_BEFORE_EDGE.equals(cSSValue)) {
            return 1;
        }
        if (AlignmentBaseline.AFTER_EDGE.equals(cSSValue)) {
            return 9;
        }
        if (AlignmentBaseline.BEFORE_EDGE.equals(cSSValue)) {
            return 0;
        }
        return n;
    }

    public static int translateBaselines(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 2: {
                return 3;
            }
            case 5: {
                return 7;
            }
            case 1: {
                return 5;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid baseline");
    }

    public static ExtendedBaselineInfo createBaselineInfo(int n, FontMetrics fontMetrics) {
        BaselineInfo baselineInfo = fontMetrics.getBaselines(n, null);
        int n2 = TextUtility.translateBaselines(baselineInfo.getDominantBaseline());
        DefaultExtendedBaselineInfo defaultExtendedBaselineInfo = new DefaultExtendedBaselineInfo(n2);
        long[] lArray = new long[10];
        lArray[6] = baselineInfo.getBaseline(4);
        lArray[3] = baselineInfo.getBaseline(2);
        lArray[2] = baselineInfo.getBaseline(0);
        lArray[7] = baselineInfo.getBaseline(5);
        lArray[5] = baselineInfo.getBaseline(1);
        lArray[4] = baselineInfo.getBaseline(3);
        lArray[0] = 0L;
        lArray[1] = 0L;
        lArray[8] = fontMetrics.getMaxHeight();
        lArray[9] = lArray[8];
        defaultExtendedBaselineInfo.setBaselines(lArray);
        return defaultExtendedBaselineInfo;
    }
}

