/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.dummy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.dummy.NullOutputStream;

public class DummyContentItem
implements ContentItem,
Serializable {
    private ContentLocation parent;
    private String name;
    private static final byte[] EMPTY_BUFFER = new byte[0];

    public DummyContentItem(ContentLocation parent, String name) {
        if (parent == null) {
            throw new NullPointerException("Parent must not be null");
        }
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    @Override
    public OutputStream getOutputStream() {
        return new NullOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(EMPTY_BUFFER);
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getContentId() {
        return RepositoryUtilities.buildName(this, "/");
    }

    @Override
    public Object getAttribute(String domain, String key) {
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.parent.getRepository();
    }

    @Override
    public boolean delete() {
        return false;
    }
}

