/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.loader;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.pentaho.loader.InputRepositoryResourceData;
import org.libreoffice.report.pentaho.loader.InputResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class InputRepositoryLoader
implements ResourceLoader {
    private final InputRepository inputRepository;

    public InputRepositoryLoader(InputRepository inputRepository) {
        if (inputRepository == null) {
            throw new NullPointerException();
        }
        this.inputRepository = inputRepository;
    }

    public boolean isSupportedKey(ResourceKey resourceKey) {
        return InputRepositoryLoader.class.getName().equals(resourceKey.getSchema());
    }

    public ResourceKey createKey(Object object, Map map) throws ResourceKeyCreationException {
        String string;
        if (object instanceof String && (string = (String)object).startsWith("sun:oo://")) {
            return new ResourceKey((Object)InputRepositoryLoader.class.getName(), (Object)new InputResourceKey(this.inputRepository.getId(), string), map);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey resourceKey, String string, Map map) throws ResourceKeyCreationException {
        HashMap hashMap;
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceKeyCreationException("Assertion: Unsupported parent key type");
        }
        InputResourceKey inputResourceKey = (InputResourceKey)resourceKey.getIdentifier();
        String string2 = string.startsWith("sun:oo://") ? string : (string.charAt(0) == '/' ? "sun:oo:/" + string : LoaderUtils.mergePaths((String)inputResourceKey.getPath(), (String)string));
        if (map != null) {
            hashMap = new HashMap();
            hashMap.putAll(resourceKey.getFactoryParameters());
            hashMap.putAll(map);
        } else {
            hashMap = resourceKey.getFactoryParameters();
        }
        return new ResourceKey(resourceKey.getSchema(), (Object)new InputResourceKey(inputResourceKey.getInputRepositoryId(), string2), hashMap);
    }

    public URL toURL(ResourceKey resourceKey) {
        return null;
    }

    public ResourceData load(ResourceKey resourceKey) throws ResourceLoadingException {
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceLoadingException("None of my keys.");
        }
        return new InputRepositoryResourceData(resourceKey, this.inputRepository);
    }

    public boolean isSupportedDeserializer(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String serialize(ResourceKey resourceKey, ResourceKey resourceKey2) throws ResourceException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ResourceKey deserialize(ResourceKey resourceKey, String string) throws ResourceKeyCreationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

