/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetResultSetRequest;
import org.apache.derby.client.net.NetXACallInfo;

class NetXAConnectionRequest
extends NetResultSetRequest {
    NetXAConnectionRequest(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    @Override
    public void writeLocalXACommit(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        Xid xid = callInfo.xid_;
        this.buildSYNCCTLMigrate();
        this.buildSYNCCTLCommit(0x10000000, xid);
    }

    @Override
    public void writeLocalXARollback(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        this.buildSYNCCTLRollback(0x10000000);
    }

    @Override
    public void writeXaStartUnitOfWork(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        Xid xid = callInfo.xid_;
        int xaFlags = callInfo.xaFlags_;
        long xaTimeout = callInfo.xaTimeoutMillis_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 9);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        if (xaTimeout >= 0L && xaFlags == 0) {
            this.writeXATimeout(6407, xaTimeout);
        }
        this.updateLengthBytes();
    }

    @Override
    public void writeXaEndUnitOfWork(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        Xid xid = callInfo.xid_;
        int xaFlags = callInfo.xaFlags_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 11);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaPrepare(NetConnection conn) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        Xid xid = callInfo.xid_;
        int xaFlags = 0;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 1);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaCommit(NetConnection conn, Xid xid) throws SqlException {
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        int xaFlags = callInfo.xaFlags_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 3);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaRollback(NetConnection conn, Xid xid) throws SqlException {
        int xaFlags = 0;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 4);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaRecover(NetConnection conn, int flag) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 12);
        this.writeXAFlags(6403, flag);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaForget(NetConnection conn, Xid xid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 6);
        this.writeXID(6145, xid);
        this.updateLengthBytes();
    }

    @Override
    public void writeSYNCType(int codepoint, int syncType) {
        this.writeScalar1Byte(codepoint, syncType);
    }

    @Override
    public void writeForget(int codepoint, int value) {
        this.writeScalar1Byte(codepoint, value);
    }

    @Override
    public void writeReleaseConversation(int codepoint, int value) {
        this.writeScalar1Byte(codepoint, value);
    }

    @Override
    void writeNullXID(int codepoint) {
        int nullXID = -1;
        this.writeScalar4Bytes(codepoint, nullXID);
    }

    @Override
    void writeXID(int codepoint, Xid xid) throws SqlException {
        int len = 0;
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        this.markLengthBytes(codepoint);
        len = 4;
        len += bqual.length + 4;
        len += gtrid.length + 4;
        this.write4Bytes(formatId);
        this.write4Bytes(gtrid.length);
        this.write4Bytes(bqual.length);
        this.writeBytes(gtrid);
        this.writeBytes(bqual);
        this.updateLengthBytes();
    }

    @Override
    void writeXAFlags(int codepoint, int xaFlags) {
        this.writeScalar4Bytes(codepoint, xaFlags);
    }

    @Override
    void writeXATimeout(int codepoint, long xaTimeout) {
        this.writeScalar8Bytes(codepoint, xaTimeout);
    }

    @Override
    void buildSYNCCTLMigrate() throws SqlException {
    }

    @Override
    void buildSYNCCTLCommit(int xaFlags, Xid xid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 3);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }

    @Override
    void buildSYNCCTLRollback(int xaFlags) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 4);
        this.writeNullXID(6145);
        this.writeXAFlags(6403, xaFlags);
        this.updateLengthBytes();
    }
}

