/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.sanity;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class AssertFailure
extends RuntimeException {
    private String threadDump = this.dumpThreads();

    public AssertFailure(String message, Throwable nestedError) {
        super(message, nestedError);
    }

    public AssertFailure(String message) {
        super(message);
    }

    public AssertFailure() {
    }

    public String getThreadDump() {
        return this.threadDump;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        s.println(this.threadDump);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        s.println(this.threadDump);
    }

    private boolean supportsThreadDump() {
        try {
            Thread.class.getMethod("getAllStackTraces", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private String dumpThreads() {
        Method m;
        if (!this.supportsThreadDump()) {
            return "(Skipping thread dump because it is not supported on JVM 1.4)";
        }
        StringWriter out = new StringWriter();
        PrintWriter p = new PrintWriter((Writer)out, true);
        try {
            Class<?> c = Class.forName("org.apache.derby.shared.common.sanity.ThreadDump");
            m = c.getMethod("getStackDumpString", new Class[0]);
        }
        catch (Exception e) {
            p.println("Failed to load class/method required to generate a thread dump:");
            e.printStackTrace(p);
            return out.toString();
        }
        try {
            String dump = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    return m.invoke(null, (Object[])null);
                }
            });
            p.print("---------------\nStack traces for all live threads:");
            p.println("\n" + dump);
            p.println("---------------");
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof InvocationTargetException && cause.getCause() instanceof AccessControlException) {
                p.println("(Skipping thread dump because of insufficient permissions:\n" + String.valueOf(cause.getCause()) + ")\n");
            }
            p.println("\nAssertFailure tried to do a thread dump, but there was an error:");
            cause.printStackTrace(p);
        }
        return out.toString();
    }
}

