/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.diag.ConglomInfo;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class SpaceTable
extends VTITemplate
implements VTICosting {
    private ConglomInfo[] conglomTable;
    boolean initialized;
    int currentRow;
    private boolean wasNull;
    private String schemaName;
    private String tableName;
    private SpaceInfo spaceInfo;
    private TransactionController tc;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("CONGLOMERATENAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("ISINDEX", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMALLOCATEDPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMFREEPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMUNFILLEDPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("PAGESIZE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("ESTIMSPACESAVING", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("TABLEID", 1, false, 36)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public SpaceTable() {
    }

    public SpaceTable(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public SpaceTable(String tableName) {
        this.tableName = tableName;
    }

    private void getConglomInfo(LanguageConnectionContext lcc) throws StandardException {
        ConglomerateDescriptor[] cds;
        DataDictionary dd = lcc.getDataDictionary();
        if (this.schemaName == null) {
            this.schemaName = lcc.getCurrentSchemaName();
        }
        if (this.tableName != null) {
            SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, this.tc, true);
            TableDescriptor td = dd.getTableDescriptor(this.tableName, sd, this.tc);
            if (td == null) {
                this.conglomTable = new ConglomInfo[0];
                return;
            }
            cds = td.getConglomerateDescriptors();
        } else {
            cds = dd.getConglomerateDescriptors(null);
        }
        this.conglomTable = new ConglomInfo[cds.length];
        for (int i = 0; i < cds.length; ++i) {
            String conglomerateName = cds[i].isIndex() ? cds[i].getConglomerateName() : (this.tableName != null ? this.tableName : dd.getTableDescriptor(cds[i].getTableID()).getName());
            this.conglomTable[i] = new ConglomInfo(cds[i].getTableID().toString(), cds[i].getConglomerateNumber(), conglomerateName, cds[i].isIndex());
        }
    }

    private void getSpaceInfo(int index) throws StandardException {
        ConglomerateController cc = this.tc.openConglomerate(this.conglomTable[index].getConglomId(), false, 0, 6, 2);
        this.spaceInfo = cc.getSpaceInfo();
        cc.close();
        cc = null;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
                this.tc = lcc.getTransactionExecute();
                this.getConglomInfo(lcc);
                this.initialized = true;
                this.currentRow = -1;
            }
            if (this.conglomTable == null) {
                return false;
            }
            ++this.currentRow;
            if (this.currentRow >= this.conglomTable.length) {
                return false;
            }
            this.spaceInfo = null;
            this.getSpaceInfo(this.currentRow);
            return true;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException((StandardException)se);
        }
    }

    @Override
    public void close() {
        this.conglomTable = null;
        this.spaceInfo = null;
        this.tc = null;
    }

    @Override
    public String getString(int columnNumber) {
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        String str = null;
        switch (columnNumber) {
            case 1: {
                str = conglomInfo.getConglomName();
                break;
            }
            case 8: {
                str = conglomInfo.getTableID();
                break;
            }
        }
        this.wasNull = str == null;
        return str;
    }

    @Override
    public long getLong(int columnNumber) {
        long longval;
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        switch (columnNumber) {
            case 3: {
                longval = this.spaceInfo.getNumAllocatedPages();
                break;
            }
            case 4: {
                longval = this.spaceInfo.getNumFreePages();
                break;
            }
            case 5: {
                longval = this.spaceInfo.getNumUnfilledPages();
                break;
            }
            case 7: {
                int psize = this.spaceInfo.getPageSize();
                longval = this.spaceInfo.getNumFreePages() * (long)psize;
                break;
            }
            default: {
                longval = -1L;
            }
        }
        this.wasNull = false;
        if (longval < 0L) {
            SanityManager.THROWASSERT((String)("SpaceTable column number " + columnNumber + " has a negative value at row " + this.currentRow));
        }
        return longval;
    }

    @Override
    public short getShort(int columnNumber) {
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        this.wasNull = false;
        return (short)(conglomInfo.getIsIndex() ? 1 : 0);
    }

    @Override
    public int getInt(int columnNumber) {
        return this.spaceInfo.getPageSize();
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) {
        return 10000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) {
        return 100000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) {
        return true;
    }
}

