/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class MaterializeResultSetNode
extends SingleChildResultSetNode {
    MaterializeResultSetNode(ResultSetNode childResult, ResultColumnList rcl, Properties tableProperties, ContextManager cm) {
        super(childResult, tableProperties, cm);
        this.setResultColumns(rcl);
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((this.getResultColumns() != null ? 1 : 0) != 0, (String)"Tree structure bad");
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(this.getResultSetNumber());
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getMaterializedResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 4);
    }
}

