/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class DropTriggerConstantAction
extends DDLSingleTableConstantAction {
    private final String triggerName;
    private final SchemaDescriptor sd;

    DropTriggerConstantAction(SchemaDescriptor sd, String triggerName, UUID tableId) {
        super(tableId);
        this.sd = sd;
        this.triggerName = triggerName;
        SanityManager.ASSERT((sd != null ? 1 : 0) != 0, (String)"SchemaDescriptor is null");
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        TableDescriptor td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{this.tableId.toString()});
        }
        TransactionController tc = lcc.getTransactionExecute();
        this.lockTableForDDL(tc, td.getHeapConglomerateId(), true);
        td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{this.tableId.toString()});
        }
        TriggerDescriptor triggerd = dd.getTriggerDescriptor(this.triggerName, this.sd);
        if (triggerd == null) {
            throw StandardException.newException((String)"X0X81.S", (Object[])new Object[]{"TRIGGER", this.sd.getSchemaName() + "." + this.triggerName});
        }
        triggerd.drop(lcc);
    }

    public String toString() {
        return "DROP TRIGGER " + this.triggerName;
    }
}

