/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.log;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;

@Plugin(name="PipelineRoutingFilter", category="Core", elementType="appender", printObject=true)
public final class PipelineRoutingFilter
extends AbstractFilter {
    private final boolean isSeparateLogs = Boolean.getBoolean("ls.pipeline.separate_logs");

    @PluginFactory
    public static PipelineRoutingFilter createFilter() {
        return new PipelineRoutingFilter();
    }

    private PipelineRoutingFilter() {
    }

    public Filter.Result filter(LogEvent event) {
        boolean directedToPipelineLog;
        boolean bl = directedToPipelineLog = this.isSeparateLogs && event.getContextData().containsKey("pipeline.id");
        if (directedToPipelineLog) {
            return Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }
}

