/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.lolevel.HTTPCallback;
import http_parser.lolevel.HTTPDataCallback;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.Message;
import http_parser.lolevel.ParserSettings;
import java.nio.ByteBuffer;
import java.util.List;
import primitive.collection.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static final ParserSettings SETTINGS_NULL = new ParserSettings();

    static String str(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = byteBuffer.position();
        byteBuffer.position(n);
        byteBuffer.get(byArray);
        byteBuffer.position(n3);
        return new String(byArray);
    }

    static String str(ByteBuffer byteBuffer) {
        int n = byteBuffer.limit() - byteBuffer.position();
        byte[] byArray = new byte[n];
        int n2 = byteBuffer.position();
        byteBuffer.get(byArray);
        byteBuffer.position(n2);
        return new String(byArray);
    }

    static ByteBuffer buffer(String string) {
        return ByteBuffer.wrap(string.getBytes());
    }

    static ByteBuffer empty() {
        return ByteBuffer.wrap(new byte[0]);
    }

    static void check(boolean bl) {
        if (!bl) {
            throw new RuntimeException("!");
        }
    }

    static void check(int n, int n2) {
        if (n != n2) {
            throw new RuntimeException("should be: " + n + " is:" + n2);
        }
    }

    static void test_message(Message message) {
        int n = message.raw.length;
        for (int i = 0; i != n; ++i) {
            message.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(message.raw, 0, i);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(message.raw, i, message.raw.length - i);
            HTTPParser hTTPParser = new HTTPParser(message.type);
            Message.TestSettings testSettings = message.settings();
            int n2 = 0;
            if (i != 0) {
                n2 = hTTPParser.execute(testSettings, byteBuffer);
                if (message.upgrade() && hTTPParser.upgrade) {
                    Util.check(1 == message.num_called);
                    continue;
                }
                Util.check(n2 == i);
            }
            n2 = hTTPParser.execute(testSettings, byteBuffer2);
            if (message.upgrade() && hTTPParser.upgrade) {
                Util.check(1 == message.num_called);
                continue;
            }
            Util.check(message.raw.length - i, n2);
            ByteBuffer byteBuffer3 = Util.empty();
            n2 = hTTPParser.execute(testSettings, byteBuffer3);
            if (message.upgrade() && hTTPParser.upgrade) {
                Util.check(1 == message.num_called);
                continue;
            }
            Util.check(byteBuffer3.position() == byteBuffer3.limit());
            Util.check(0 == n2);
            Util.check(1 == message.num_called);
        }
    }

    static void test_multiple3(Message message, Message message2, Message message3) {
        int n = 1;
        if (!message.upgrade()) {
            ++n;
            if (!message2.upgrade()) {
                ++n;
            }
        }
        boolean bl = n < 3 || message3.upgrade();
        ByteList byteList = new ByteList();
        byteList.addAll(message.raw);
        byteList.addAll(message2.raw);
        byteList.addAll(message3.raw);
        byte[] byArray = byteList.toArray();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Settings settings = Util.settings();
        HTTPParser hTTPParser = new HTTPParser(message.type);
        int n2 = hTTPParser.execute(settings, byteBuffer);
        if (bl && hTTPParser.upgrade) {
            byArray = Util.upgrade_message_fix(byArray, n2, message, message2, message3);
            Util.check(settings.numCalled == n);
            return;
        }
        Util.check(n2 == byArray.length);
        byteBuffer = Util.empty();
        n2 = hTTPParser.execute(settings, byteBuffer);
        if (bl && hTTPParser.upgrade) {
            Util.check(settings.numCalled == n);
            return;
        }
        Util.check(0 == n2);
        Util.check(settings.numCalled == n);
    }

    static byte[] upgrade_message_fix(byte[] byArray, int n, Message ... messageArray) {
        int n2 = 0;
        for (Message message : messageArray) {
            n2 += message.raw.length;
            if (!message.upgrade()) continue;
            Util.check(n2 -= message.upgrade.length, n);
            return new byte[n2];
        }
        return null;
    }

    static void p(Object object) {
        System.out.println(object);
    }

    static Settings settings() {
        return new Settings();
    }

    static Message find(List<Message> list, String string) {
        for (Message message : list) {
            if (!string.equals(message.name)) continue;
            return message;
        }
        return null;
    }

    static class Settings
    extends ParserSettings {
        public int numCalled;
        public int bodyCount;

        Settings() {
            this.on_message_complete = new HTTPCallback(){

                public int cb(HTTPParser hTTPParser) {
                    ++Settings.this.numCalled;
                    return 0;
                }
            };
            this.on_body = new HTTPDataCallback(){

                public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                    Settings.this.bodyCount += n2;
                    return 0;
                }
            };
        }

        int numCalled() {
            return this.numCalled;
        }
    }
}

