/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.internal.producers.SingleProducer;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class AsyncSubject<T>
extends Subject<T, T> {
    final SubjectSubscriptionManager<T> state;
    volatile Object lastValue;

    public static <T> AsyncSubject<T> create() {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        state.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                Object v = state.getLatest();
                if (v == null || NotificationLite.isCompleted(v)) {
                    o.onCompleted();
                } else if (NotificationLite.isError(v)) {
                    o.onError(NotificationLite.getError(v));
                } else {
                    o.actual.setProducer(new SingleProducer(o.actual, NotificationLite.getValue(v)));
                }
            }
        };
        return new AsyncSubject(state, state);
    }

    protected AsyncSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        if (this.state.active) {
            Object last = this.lastValue;
            if (last == null) {
                last = NotificationLite.completed();
            }
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(last)) {
                if (last == NotificationLite.completed()) {
                    bo.onCompleted();
                    continue;
                }
                bo.actual.setProducer(new SingleProducer(bo.actual, NotificationLite.getValue(last)));
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.state.active) {
            Object n = NotificationLite.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(n)) {
                try {
                    bo.onError(e);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            Exceptions.throwIfAny(errors);
        }
    }

    @Override
    public void onNext(T v) {
        this.lastValue = NotificationLite.next(v);
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }

    public boolean hasValue() {
        Object v = this.lastValue;
        Object o = this.state.getLatest();
        return !NotificationLite.isError(o) && NotificationLite.isNext(v);
    }

    public boolean hasThrowable() {
        Object o = this.state.getLatest();
        return NotificationLite.isError(o);
    }

    public boolean hasCompleted() {
        Object o = this.state.getLatest();
        return o != null && !NotificationLite.isError(o);
    }

    public T getValue() {
        Object v = this.lastValue;
        Object o = this.state.getLatest();
        if (!NotificationLite.isError(o) && NotificationLite.isNext(v)) {
            return NotificationLite.getValue(v);
        }
        return null;
    }

    public Throwable getThrowable() {
        Object o = this.state.getLatest();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }
}

