/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public final class ErrorMessages
extends VTITemplate
implements VTICosting,
PrivilegedAction<InputStream> {
    private Properties p;
    private Enumeration keys;
    private String k;
    private String SQLState;
    private String message;
    private int severity;
    private int msgFile;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SQL_STATE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("MESSAGE", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("SEVERITY", 4, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public ErrorMessages() throws IOException {
        this.loadProperties();
    }

    @Override
    public boolean next() {
        boolean retCode = true;
        if (!this.keys.hasMoreElements()) {
            this.close();
            retCode = false;
            return retCode;
        }
        this.k = (String)this.keys.nextElement();
        if (this.notAnException()) {
            retCode = this.next();
        }
        if (retCode) {
            this.SQLState = StandardException.getSQLStateFromIdentifier((String)this.k);
            this.message = MessageService.getTextMessage((String)this.k, (Object[])new Object[0]);
            this.message = StringUtil.truncate(this.message, 32672);
        }
        return retCode;
    }

    @Override
    public void close() {
        this.p = null;
        this.k = null;
        this.keys = null;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        switch (columnIndex) {
            case 1: {
                return this.SQLState;
            }
            case 2: {
                return this.message;
            }
        }
        return super.getString(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        switch (columnIndex) {
            case 3: {
                return this.severity;
            }
        }
        return super.getInt(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws IOException {
        this.p = new Properties();
        for (int i = 0; i < 50; ++i) {
            this.msgFile = i;
            InputStream is = AccessController.doPrivileged(this);
            if (is == null) continue;
            try {
                this.p.load(is);
                continue;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.keys = this.p.keys();
    }

    private boolean notAnException() {
        if (this.k.length() < 5) {
            return true;
        }
        int tempSeverity = StandardException.getSeverityFromIdentifier((String)this.k);
        if (tempSeverity < 1) {
            return true;
        }
        this.severity = tempSeverity;
        return false;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) {
        return 1000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) {
        return 5000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) {
        return true;
    }

    @Override
    public final InputStream run() {
        InputStream msg = this.getClass().getResourceAsStream("/org/apache/derby/loc/m" + this.msgFile + "_en.properties");
        this.msgFile = 0;
        return msg;
    }
}

