/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.derby.iapi.tools.ToolUtils;
import org.apache.derby.impl.tools.ij.ijResultImpl;

public class ijResultSetResult
extends ijResultImpl {
    private ResultSet resultSet;
    private Statement statement;
    private int[] displayColumns = null;
    private int[] columnWidths = null;

    public ijResultSetResult(ResultSet r) throws SQLException {
        this.resultSet = r;
        this.statement = this.resultSet.getStatement();
    }

    public ijResultSetResult(ResultSet r, int[] display, int[] widths) throws SQLException {
        this.resultSet = r;
        this.statement = this.resultSet.getStatement();
        this.displayColumns = ToolUtils.copy(display);
        this.columnWidths = ToolUtils.copy(widths);
    }

    @Override
    public boolean isResultSet() throws SQLException {
        return this.statement == null || this.statement.getUpdateCount() == -1;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public void closeStatement() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        } else {
            this.resultSet.close();
        }
    }

    @Override
    public int[] getColumnDisplayList() {
        return ToolUtils.copy(this.displayColumns);
    }

    @Override
    public int[] getColumnWidthList() {
        return ToolUtils.copy(this.columnWidths);
    }

    @Override
    public SQLWarning getSQLWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    @Override
    public void clearSQLWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }
}

