/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.fluent.TargetBuilder;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;

public class PduBuilder {
    protected final TargetBuilder<?> targetBuilder;
    protected OctetString contextEngineID;
    protected OctetString contextName;
    protected int pduType = -96;
    protected List<VariableBinding> vbs = new ArrayList<VariableBinding>();

    protected PduBuilder(TargetBuilder<?> targetBuilder) {
        this.targetBuilder = targetBuilder;
    }

    public PduBuilder contextName(String contextName) {
        return this.contextName(OctetString.fromString(contextName));
    }

    public PduBuilder contextName(OctetString contextName) {
        this.contextName = contextName;
        return this;
    }

    public PduBuilder contextEngineID(byte[] contextEngineID) {
        return this.contextEngineID(OctetString.fromByteArray(contextEngineID));
    }

    public PduBuilder contextEngineID(OctetString contextEngineID) {
        this.contextEngineID = contextEngineID;
        return this;
    }

    public PduBuilder type(int pduType) {
        this.pduType = pduType;
        return this;
    }

    public PduBuilder oid(OID ... oids) {
        for (OID oid : oids) {
            this.vbs.add(new VariableBinding(oid));
        }
        return this;
    }

    public PduBuilder oids(String ... oids) {
        for (String objectID : oids) {
            this.vbs.add(new VariableBinding(new OID(objectID)));
        }
        return this;
    }

    public PduBuilder vb(OID oid, Variable value) {
        this.vbs.add(new VariableBinding(oid, value));
        return this;
    }

    public PduBuilder vbs(VariableBinding ... vbs) {
        Collections.addAll(this.vbs, vbs);
        return this;
    }

    public PDU build() {
        PDU pdu = DefaultPDUFactory.createPDU(this.targetBuilder.snmpVersion.getVersion());
        if (pdu instanceof ScopedPDU) {
            ScopedPDU scopedPDU = (ScopedPDU)pdu;
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            scopedPDU.setContextName(this.contextName);
        }
        pdu.setType(this.pduType);
        pdu.setVariableBindings(this.vbs);
        return pdu;
    }
}

