/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECCPublicKey;
import software.amazon.cryptography.primitives.model.ECDHCurveSpec;

public class CompressPublicKeyInput {
    private final ECCPublicKey publicKey;
    private final ECDHCurveSpec eccCurve;

    protected CompressPublicKeyInput(BuilderImpl builder) {
        this.publicKey = builder.publicKey();
        this.eccCurve = builder.eccCurve();
    }

    public ECCPublicKey publicKey() {
        return this.publicKey;
    }

    public ECDHCurveSpec eccCurve() {
        return this.eccCurve;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECCPublicKey publicKey;
        protected ECDHCurveSpec eccCurve;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CompressPublicKeyInput model) {
            this.publicKey = model.publicKey();
            this.eccCurve = model.eccCurve();
        }

        @Override
        public Builder publicKey(ECCPublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public ECCPublicKey publicKey() {
            return this.publicKey;
        }

        @Override
        public Builder eccCurve(ECDHCurveSpec eccCurve) {
            this.eccCurve = eccCurve;
            return this;
        }

        @Override
        public ECDHCurveSpec eccCurve() {
            return this.eccCurve;
        }

        @Override
        public CompressPublicKeyInput build() {
            if (Objects.isNull(this.publicKey())) {
                throw new IllegalArgumentException("Missing value for required field `publicKey`");
            }
            if (Objects.isNull((Object)this.eccCurve())) {
                throw new IllegalArgumentException("Missing value for required field `eccCurve`");
            }
            return new CompressPublicKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder publicKey(ECCPublicKey var1);

        public ECCPublicKey publicKey();

        public Builder eccCurve(ECDHCurveSpec var1);

        public ECDHCurveSpec eccCurve();

        public CompressPublicKeyInput build();
    }
}

