/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.opensearch.common.Nullable;
import org.opensearch.common.ssl.KeyStoreUtil;
import org.opensearch.common.ssl.SslConfigException;
import org.opensearch.common.ssl.SslTrustConfig;

final class DefaultJdkTrustConfig
implements SslTrustConfig {
    private final BiFunction<String, String, String> systemProperties;
    private final char[] trustStorePassword;

    DefaultJdkTrustConfig() {
        this(System::getProperty);
    }

    DefaultJdkTrustConfig(BiFunction<String, String, String> systemProperties) {
        this(systemProperties, DefaultJdkTrustConfig.isPkcs11Truststore(systemProperties) ? DefaultJdkTrustConfig.getSystemTrustStorePassword(systemProperties) : null);
    }

    DefaultJdkTrustConfig(BiFunction<String, String, String> systemProperties, @Nullable char[] trustStorePassword) {
        this.systemProperties = systemProperties;
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public X509ExtendedTrustManager createTrustManager() {
        try {
            return KeyStoreUtil.createTrustManager(this.getSystemTrustStore(), TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("failed to initialize a TrustManager for the system keystore", e);
        }
    }

    private KeyStore getSystemTrustStore() {
        if (DefaultJdkTrustConfig.isPkcs11Truststore(this.systemProperties) && this.trustStorePassword != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS11");
                keyStore.load(null, this.trustStorePassword);
                return keyStore;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new SslConfigException("failed to load the system PKCS#11 truststore", e);
            }
        }
        if (KeyStoreUtil.IN_FIPS_MODE && !DefaultJdkTrustConfig.isBcfksTruststore(this.systemProperties) && !DefaultJdkTrustConfig.isPkcs11Truststore(this.systemProperties)) {
            throw new SslConfigException("only [" + String.valueOf(KeyStoreUtil.FIPS_COMPLIANT_KEYSTORE_TYPES) + "] truststores are supported in a FIPS JVM");
        }
        return null;
    }

    private static boolean isPkcs11Truststore(BiFunction<String, String, String> systemProperties) {
        return systemProperties.apply("javax.net.ssl.trustStoreType", "").equalsIgnoreCase("PKCS11");
    }

    private static boolean isBcfksTruststore(BiFunction<String, String, String> systemProperties) {
        return systemProperties.apply("javax.net.ssl.trustStoreType", "").equalsIgnoreCase("BCFKS");
    }

    private static char[] getSystemTrustStorePassword(BiFunction<String, String, String> systemProperties) {
        return systemProperties.apply("javax.net.ssl.trustStorePassword", "").toCharArray();
    }

    @Override
    public Collection<Path> getDependentFiles() {
        return Collections.emptyList();
    }

    public String toString() {
        return "JDK-trusted-certs";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJdkTrustConfig that = (DefaultJdkTrustConfig)o;
        return Arrays.equals(this.trustStorePassword, that.trustStorePassword);
    }

    public int hashCode() {
        return Arrays.hashCode(this.trustStorePassword);
    }
}

