/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.indices;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteAction;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetAction;
import org.opensearch.action.get.GetRequestBuilder;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.knn.common.exception.DeleteModelException;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.indices.Model;
import org.opensearch.knn.indices.ModelGraveyard;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelState;
import org.opensearch.knn.plugin.transport.DeleteModelResponse;
import org.opensearch.knn.plugin.transport.GetModelResponse;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheAction;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheRequest;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheResponse;
import org.opensearch.knn.plugin.transport.UpdateModelGraveyardAction;
import org.opensearch.knn.plugin.transport.UpdateModelGraveyardRequest;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataAction;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataRequest;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

public interface ModelDao {
    public void create(ActionListener<CreateIndexResponse> var1) throws IOException;

    public boolean isCreated();

    public ClusterHealthStatus getHealthStatus();

    public void put(Model var1, ActionListener<IndexResponse> var2) throws IOException;

    public void update(Model var1, ActionListener<IndexResponse> var2) throws IOException;

    public Model get(String var1) throws ExecutionException, InterruptedException;

    public void get(String var1, ActionListener<GetModelResponse> var2);

    public void search(SearchRequest var1, ActionListener<SearchResponse> var2) throws IOException;

    public ModelMetadata getMetadata(String var1);

    public void delete(String var1, ActionListener<DeleteModelResponse> var2);

    public boolean isModelInGraveyard(String var1);

    private static void runWithStashedThreadContext(Runnable function) {
        try (ThreadContext.StoredContext context = OpenSearchKNNModelDao.client.threadPool().getThreadContext().stashContext();){
            function.run();
        }
    }

    private static <T> T runWithStashedThreadContext(Supplier<T> function) {
        try (ThreadContext.StoredContext context = OpenSearchKNNModelDao.client.threadPool().getThreadContext().stashContext();){
            T t = function.get();
            return t;
        }
    }

    public static final class OpenSearchKNNModelDao
    implements ModelDao {
        public static Logger logger = LogManager.getLogger(ModelDao.class);
        private int numberOfShards = (Integer)KNNSettings.MODEL_INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        private int numberOfReplicas = (Integer)KNNSettings.MODEL_INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings);
        private static volatile OpenSearchKNNModelDao INSTANCE;
        private static Client client;
        private static ClusterService clusterService;
        private static Settings settings;

        public static synchronized OpenSearchKNNModelDao getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new OpenSearchKNNModelDao();
            }
            return INSTANCE;
        }

        public static void initialize(Client client, ClusterService clusterService, Settings settings) {
            OpenSearchKNNModelDao.client = client;
            OpenSearchKNNModelDao.clusterService = clusterService;
            OpenSearchKNNModelDao.settings = settings;
        }

        private OpenSearchKNNModelDao() {
            clusterService.getClusterSettings().addSettingsUpdateConsumer(KNNSettings.MODEL_INDEX_NUMBER_OF_SHARDS_SETTING, it -> {
                this.numberOfShards = it;
            });
            clusterService.getClusterSettings().addSettingsUpdateConsumer(KNNSettings.MODEL_INDEX_NUMBER_OF_REPLICAS_SETTING, it -> {
                this.numberOfReplicas = it;
            });
        }

        @Override
        public void create(ActionListener<CreateIndexResponse> actionListener) throws IOException {
            if (this.isCreated()) {
                return;
            }
            ModelDao.runWithStashedThreadContext(() -> {
                CreateIndexRequest request;
                try {
                    request = new CreateIndexRequest(".opensearch-knn-models").mapping(this.getMapping()).settings(Settings.builder().put("index.hidden", true).put("index.number_of_shards", this.numberOfShards).put("index.number_of_replicas", this.numberOfReplicas));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                client.admin().indices().create(request, actionListener);
            });
        }

        @Override
        public boolean isCreated() {
            return clusterService.state().getRoutingTable().hasIndex(".opensearch-knn-models");
        }

        @Override
        public ClusterHealthStatus getHealthStatus() throws IndexNotFoundException {
            if (!this.isCreated()) {
                throw new IndexNotFoundException(".opensearch-knn-models");
            }
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(clusterService.state().metadata().index(".opensearch-knn-models"), clusterService.state().getRoutingTable().index(".opensearch-knn-models"));
            return indexHealth.getStatus();
        }

        @Override
        public void put(Model model, ActionListener<IndexResponse> listener) throws IOException {
            this.putInternal(model, listener, DocWriteRequest.OpType.CREATE);
        }

        @Override
        public void update(Model model, ActionListener<IndexResponse> listener) throws IOException {
            this.putInternal(model, listener, DocWriteRequest.OpType.INDEX);
        }

        private void putInternal(final Model model, ActionListener<IndexResponse> listener, DocWriteRequest.OpType requestOpType) throws IOException {
            if (model == null) {
                throw new IllegalArgumentException("Model cannot be null");
            }
            final ModelMetadata modelMetadata = model.getModelMetadata();
            HashMap<String, Object> parameters = new HashMap<String, Object>(this){
                final /* synthetic */ OpenSearchKNNModelDao this$0;
                {
                    this.this$0 = this$0;
                    this.put("model_id", model.getModelID());
                    this.put("engine", modelMetadata.getKnnEngine().getName());
                    this.put("space_type", modelMetadata.getSpaceType().getValue());
                    this.put("dimension", modelMetadata.getDimension());
                    this.put("state", modelMetadata.getState().getName());
                    this.put("timestamp", modelMetadata.getTimestamp());
                    this.put("description", modelMetadata.getDescription());
                    this.put("error", modelMetadata.getError());
                    this.put("training_node_assignment", modelMetadata.getNodeAssignment());
                    this.put("data_type", modelMetadata.getVectorDataType());
                    if (Mode.isConfigured(modelMetadata.getMode())) {
                        this.put("mode", modelMetadata.getMode().getName());
                    }
                    if (CompressionLevel.isConfigured(modelMetadata.getCompressionLevel())) {
                        this.put("compression_level", modelMetadata.getCompressionLevel().getName());
                    }
                    this.put("model_version", modelMetadata.getModelVersion());
                    MethodComponentContext methodComponentContext = modelMetadata.getMethodComponentContext();
                    if (!methodComponentContext.getName().isEmpty()) {
                        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                        builder = methodComponentContext.toXContent(builder, ToXContent.EMPTY_PARAMS).endObject();
                        this.put("model_definition", builder.toString());
                    }
                }
            };
            byte[] modelBlob = model.getModelBlob();
            if (modelBlob == null && ModelState.CREATED.equals((Object)modelMetadata.getState())) {
                throw new IllegalArgumentException("Model binary cannot be null when model state is CREATED");
            }
            if (modelBlob != null) {
                String base64Model = Base64.getEncoder().encodeToString(modelBlob);
                parameters.put("model_blob", base64Model);
            }
            IndexRequestBuilder indexRequestBuilder = client.prepareIndex(".opensearch-knn-models");
            indexRequestBuilder.setId(model.getModelID());
            indexRequestBuilder.setSource((Map)parameters);
            indexRequestBuilder.setOpType(requestOpType);
            indexRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            ActionListener onMetaListener = ActionListener.wrap(indexResponse -> client.execute((ActionType)RemoveModelFromCacheAction.INSTANCE, (ActionRequest)new RemoveModelFromCacheRequest(model.getModelID(), new String[0]), ActionListener.wrap(removeModelFromCacheResponse -> {
                if (!removeModelFromCacheResponse.hasFailures()) {
                    listener.onResponse(indexResponse);
                    return;
                }
                String failureMessage = this.buildRemoveModelErrorMessage(model.getModelID(), (RemoveModelFromCacheResponse)((Object)((Object)removeModelFromCacheResponse)));
                listener.onFailure((Exception)new RuntimeException(failureMessage));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
            ActionListener<IndexResponse> onIndexListener = this.getUpdateModelMetadataListener(model.getModelMetadata(), (ActionListener<IndexResponse>)onMetaListener);
            Runnable indexModelRunnable = () -> indexRequestBuilder.execute(onIndexListener);
            if (!this.isCreated()) {
                this.create((ActionListener<CreateIndexResponse>)ActionListener.wrap(createIndexResponse -> ModelDao.runWithStashedThreadContext(indexModelRunnable), arg_0 -> onIndexListener.onFailure(arg_0)));
                return;
            }
            ModelDao.runWithStashedThreadContext(indexModelRunnable);
        }

        private ActionListener<IndexResponse> getUpdateModelMetadataListener(ModelMetadata modelMetadata, ActionListener<IndexResponse> listener) {
            return ActionListener.wrap(indexResponse -> client.execute((ActionType)UpdateModelMetadataAction.INSTANCE, (ActionRequest)new UpdateModelMetadataRequest(indexResponse.getId(), false, modelMetadata), ActionListener.wrap(acknowledgedResponse -> listener.onResponse(indexResponse), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        }

        @Override
        public Model get(String modelId) {
            try {
                return ModelDao.runWithStashedThreadContext(() -> {
                    GetResponse getResponse;
                    GetRequestBuilder getRequestBuilder = new GetRequestBuilder((OpenSearchClient)client, GetAction.INSTANCE, ".opensearch-knn-models").setId(modelId).setPreference("_local");
                    try {
                        getResponse = (GetResponse)getRequestBuilder.execute().get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    Map responseMap = getResponse.getSourceAsMap();
                    return Model.getModelFromSourceMap(responseMap);
                });
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException.getCause();
            }
        }

        @Override
        public void get(String modelId, ActionListener<GetModelResponse> actionListener) {
            ModelDao.runWithStashedThreadContext(() -> {
                GetRequestBuilder getRequestBuilder = new GetRequestBuilder((OpenSearchClient)client, GetAction.INSTANCE, ".opensearch-knn-models").setId(modelId).setPreference("_local");
                getRequestBuilder.execute(ActionListener.wrap(response -> {
                    if (response.isSourceEmpty()) {
                        String errorMessage = String.format("Model \" %s \" does not exist", modelId);
                        actionListener.onFailure((Exception)new ResourceNotFoundException(modelId, new Object[]{errorMessage}));
                        return;
                    }
                    Map responseMap = response.getSourceAsMap();
                    Model model = Model.getModelFromSourceMap(responseMap);
                    actionListener.onResponse((Object)new GetModelResponse(model));
                }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
            });
        }

        @Override
        public void search(SearchRequest request, ActionListener<SearchResponse> actionListener) {
            ModelDao.runWithStashedThreadContext(() -> {
                request.indices(new String[]{".opensearch-knn-models"});
                client.search(request, actionListener);
            });
        }

        @Override
        public ModelMetadata getMetadata(String modelId) {
            IndexMetadata indexMetadata = clusterService.state().metadata().index(".opensearch-knn-models");
            if (indexMetadata == null) {
                logger.debug("ModelMetadata for model \"" + modelId + "\" is null. .opensearch-knn-models index does not exist.");
                return null;
            }
            Map models = indexMetadata.getCustomData("knn-models");
            if (models == null) {
                logger.debug("ModelMetadata for model \"" + modelId + "\" is null. .opensearch-knn-models's custom metadata does not exist.");
                return null;
            }
            String modelMetadata = (String)models.get(modelId);
            if (modelMetadata == null) {
                logger.debug("ModelMetadata for model \"" + modelId + "\" is null. Model \"" + modelId + "\" does not exist.");
                return null;
            }
            return ModelMetadata.fromString(modelMetadata);
        }

        private String getMapping() throws IOException {
            if (ModelDao.class.getClassLoader() == null) {
                throw new IllegalStateException("ClassLoader of ModelDao Class is null");
            }
            URL url = ModelDao.class.getClassLoader().getResource("mappings/model-index.json");
            if (url == null) {
                throw new IllegalStateException("Unable to retrieve mapping for \".opensearch-knn-models\"");
            }
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }

        @Override
        public boolean isModelInGraveyard(String modelId) {
            Objects.requireNonNull(clusterService.state(), "Cluster state must not be null");
            Objects.requireNonNull(clusterService.state().metadata(), "Cluster metadata must not be null");
            ModelGraveyard modelGraveyard = (ModelGraveyard)clusterService.state().metadata().custom("opensearch-knn-blocked-models");
            if (Objects.isNull(modelGraveyard)) {
                return false;
            }
            return modelGraveyard.contains(modelId);
        }

        @Override
        public void delete(String modelId, ActionListener<DeleteModelResponse> listener) {
            if (!this.isCreated()) {
                String errorMessage = String.format("Cannot delete model [%s]. Model index [%s] does not exist", modelId, ".opensearch-knn-models");
                listener.onFailure((Exception)new ResourceNotFoundException(errorMessage, new Object[0]));
                return;
            }
            StepListener getModelStep = new StepListener();
            StepListener blockModelIdStep = new StepListener();
            StepListener clearModelMetadataStep = new StepListener();
            StepListener deleteModelFromIndexStep = new StepListener();
            StepListener clearModelFromCacheStep = new StepListener();
            StepListener unblockModelIdStep = new StepListener();
            this.get(modelId, (ActionListener<GetModelResponse>)ActionListener.wrap(arg_0 -> ((StepListener)getModelStep).onResponse(arg_0), exception -> {
                if (exception instanceof ResourceNotFoundException) {
                    String errorMessage = String.format("Unable to delete model [%s]. Model does not exist", modelId);
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(errorMessage, new Object[0]);
                    this.removeModelIdFromGraveyardOnFailure(modelId, (Exception)resourceNotFoundException, getModelStep);
                } else {
                    this.removeModelIdFromGraveyardOnFailure(modelId, (Exception)exception, (StepListener<?>)getModelStep);
                }
            }));
            getModelStep.whenComplete(getModelResponse -> {
                if (ModelState.TRAINING == getModelResponse.getModel().getModelMetadata().getState()) {
                    String errorMessage = String.format("Cannot delete model [%s]. Model is still in training", modelId);
                    listener.onFailure((Exception)((Object)new DeleteModelException(errorMessage, new Object[0])));
                    return;
                }
                this.updateModelGraveyardToDelete(modelId, false, (StepListener<AcknowledgedResponse>)blockModelIdStep, Optional.empty());
            }, arg_0 -> listener.onFailure(arg_0));
            blockModelIdStep.whenComplete(acknowledgedResponse -> this.clearModelMetadata(modelId, (StepListener<AcknowledgedResponse>)clearModelMetadataStep), arg_0 -> listener.onFailure(arg_0));
            clearModelMetadataStep.whenComplete(acknowledgedResponse -> {
                DeleteRequestBuilder deleteRequestBuilder = new DeleteRequestBuilder((OpenSearchClient)client, DeleteAction.INSTANCE, ".opensearch-knn-models");
                deleteRequestBuilder.setId(modelId);
                deleteRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.deleteModelFromIndex(modelId, (StepListener<DeleteResponse>)deleteModelFromIndexStep, deleteRequestBuilder);
            }, arg_0 -> listener.onFailure(arg_0));
            deleteModelFromIndexStep.whenComplete(deleteResponse -> {
                if (deleteResponse.getResult() != DocWriteResponse.Result.DELETED) {
                    this.updateModelGraveyardToDelete(modelId, true, (StepListener<AcknowledgedResponse>)unblockModelIdStep, Optional.empty());
                    String errorMessage = String.format("Model [%s] does not exist", modelId);
                    listener.onFailure((Exception)new ResourceNotFoundException(errorMessage, new Object[0]));
                    return;
                }
                this.removeModelFromCache(modelId, (StepListener<RemoveModelFromCacheResponse>)clearModelFromCacheStep);
            }, e -> listener.onFailure((Exception)new OpenSearchException((Throwable)e)));
            clearModelFromCacheStep.whenComplete(removeModelFromCacheResponse -> {
                OpenSearchException exception = null;
                if (removeModelFromCacheResponse.hasFailures()) {
                    String failureMessage = this.buildRemoveModelErrorMessage(modelId, (RemoveModelFromCacheResponse)((Object)removeModelFromCacheResponse));
                    exception = new OpenSearchException(failureMessage, new Object[0]);
                }
                this.updateModelGraveyardToDelete(modelId, true, (StepListener<AcknowledgedResponse>)unblockModelIdStep, Optional.ofNullable(exception));
            }, e -> listener.onFailure((Exception)new OpenSearchException((Throwable)e)));
            unblockModelIdStep.whenComplete(acknowledgedResponse -> listener.onResponse((Object)new DeleteModelResponse(modelId)), arg_0 -> listener.onFailure(arg_0));
        }

        private void removeModelFromCache(String modelId, StepListener<RemoveModelFromCacheResponse> clearModelFromCacheStep) {
            client.execute((ActionType)RemoveModelFromCacheAction.INSTANCE, (ActionRequest)new RemoveModelFromCacheRequest(modelId, new String[0]), ActionListener.wrap(arg_0 -> clearModelFromCacheStep.onResponse(arg_0), exception -> this.removeModelIdFromGraveyardOnFailure(modelId, (Exception)exception, clearModelFromCacheStep)));
        }

        private void deleteModelFromIndex(String modelId, StepListener<DeleteResponse> deleteModelFromIndexStep, DeleteRequestBuilder deleteRequestBuilder) {
            ModelDao.runWithStashedThreadContext(() -> deleteRequestBuilder.execute(ActionListener.wrap(arg_0 -> ((StepListener)deleteModelFromIndexStep).onResponse(arg_0), exception -> this.removeModelIdFromGraveyardOnFailure(modelId, (Exception)exception, deleteModelFromIndexStep))));
        }

        private void updateModelGraveyardToDelete(String modelId, boolean isRemoveRequest, StepListener<AcknowledgedResponse> step, Optional<Exception> exception) {
            client.execute((ActionType)UpdateModelGraveyardAction.INSTANCE, (ActionRequest)new UpdateModelGraveyardRequest(modelId, isRemoveRequest), ActionListener.wrap(acknowledgedResponse -> {
                if (exception.isEmpty()) {
                    step.onResponse(acknowledgedResponse);
                    return;
                }
                throw (Exception)exception.get();
            }, e -> {
                String errorMessage = String.format("Failed to remove \" %s \" from Model Graveyard", modelId);
                String failureMessage = String.format("%s%s%s", errorMessage, "\n", e.getMessage());
                logger.error(failureMessage);
                if (exception.isEmpty()) {
                    step.onFailure(e);
                    return;
                }
                step.onFailure((Exception)exception.get());
            }));
        }

        private void clearModelMetadata(String modelId, StepListener<AcknowledgedResponse> clearModelMetadataStep) {
            client.execute((ActionType)UpdateModelMetadataAction.INSTANCE, (ActionRequest)new UpdateModelMetadataRequest(modelId, true, null), ActionListener.wrap(arg_0 -> clearModelMetadataStep.onResponse(arg_0), exception -> this.removeModelIdFromGraveyardOnFailure(modelId, (Exception)exception, clearModelMetadataStep)));
        }

        private void removeModelIdFromGraveyardOnFailure(String modelId, Exception exceptionFromPreviousStep, StepListener<?> step) {
            client.execute((ActionType)UpdateModelGraveyardAction.INSTANCE, (ActionRequest)new UpdateModelGraveyardRequest(modelId, true), ActionListener.wrap(acknowledgedResponse -> {
                throw exceptionFromPreviousStep;
            }, unblockingFailedException -> {
                String errorMessage = String.format("Failed to remove \" %s \" from Model Graveyard", modelId);
                String failureMessage = String.format("%s%s%s", errorMessage, "\n", unblockingFailedException.getMessage());
                logger.error(failureMessage);
                step.onFailure(exceptionFromPreviousStep);
            }));
        }

        private String buildRemoveModelErrorMessage(String modelId, RemoveModelFromCacheResponse response) {
            String failureMessage = "Failed to remove \"" + modelId + "\" from nodes: ";
            StringBuilder stringBuilder = new StringBuilder(failureMessage);
            for (FailedNodeException nodeException : response.failures()) {
                stringBuilder.append("Node \"").append(nodeException.nodeId()).append("\" ").append(nodeException.getMessage()).append("; ");
            }
            return stringBuilder.toString();
        }
    }
}

