/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.AES_GCM;

public class AESEncryptInput {
    private final AES_GCM encAlg;
    private final ByteBuffer iv;
    private final ByteBuffer key;
    private final ByteBuffer msg;
    private final ByteBuffer aad;

    protected AESEncryptInput(BuilderImpl builder) {
        this.encAlg = builder.encAlg();
        this.iv = builder.iv();
        this.key = builder.key();
        this.msg = builder.msg();
        this.aad = builder.aad();
    }

    public AES_GCM encAlg() {
        return this.encAlg;
    }

    public ByteBuffer iv() {
        return this.iv;
    }

    public ByteBuffer key() {
        return this.key;
    }

    public ByteBuffer msg() {
        return this.msg;
    }

    public ByteBuffer aad() {
        return this.aad;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected AES_GCM encAlg;
        protected ByteBuffer iv;
        protected ByteBuffer key;
        protected ByteBuffer msg;
        protected ByteBuffer aad;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AESEncryptInput model) {
            this.encAlg = model.encAlg();
            this.iv = model.iv();
            this.key = model.key();
            this.msg = model.msg();
            this.aad = model.aad();
        }

        @Override
        public Builder encAlg(AES_GCM encAlg) {
            this.encAlg = encAlg;
            return this;
        }

        @Override
        public AES_GCM encAlg() {
            return this.encAlg;
        }

        @Override
        public Builder iv(ByteBuffer iv) {
            this.iv = iv;
            return this;
        }

        @Override
        public ByteBuffer iv() {
            return this.iv;
        }

        @Override
        public Builder key(ByteBuffer key) {
            this.key = key;
            return this;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public Builder msg(ByteBuffer msg) {
            this.msg = msg;
            return this;
        }

        @Override
        public ByteBuffer msg() {
            return this.msg;
        }

        @Override
        public Builder aad(ByteBuffer aad) {
            this.aad = aad;
            return this;
        }

        @Override
        public ByteBuffer aad() {
            return this.aad;
        }

        @Override
        public AESEncryptInput build() {
            if (Objects.isNull(this.encAlg())) {
                throw new IllegalArgumentException("Missing value for required field `encAlg`");
            }
            if (Objects.isNull(this.iv())) {
                throw new IllegalArgumentException("Missing value for required field `iv`");
            }
            if (Objects.isNull(this.key())) {
                throw new IllegalArgumentException("Missing value for required field `key`");
            }
            if (Objects.isNull(this.msg())) {
                throw new IllegalArgumentException("Missing value for required field `msg`");
            }
            if (Objects.isNull(this.aad())) {
                throw new IllegalArgumentException("Missing value for required field `aad`");
            }
            return new AESEncryptInput(this);
        }
    }

    public static interface Builder {
        public Builder encAlg(AES_GCM var1);

        public AES_GCM encAlg();

        public Builder iv(ByteBuffer var1);

        public ByteBuffer iv();

        public Builder key(ByteBuffer var1);

        public ByteBuffer key();

        public Builder msg(ByteBuffer var1);

        public ByteBuffer msg();

        public Builder aad(ByteBuffer var1);

        public ByteBuffer aad();

        public AESEncryptInput build();
    }
}

