/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.allocation_explain.DiskUsage;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeDiskUsage
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeDiskUsage> {
    @Nonnull
    private final DiskUsage leastAvailable;
    @Nonnull
    private final DiskUsage mostAvailable;
    @Nonnull
    private final String nodeName;
    public static final JsonpDeserializer<NodeDiskUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeDiskUsage::setupNodeDiskUsageDeserializer);

    private NodeDiskUsage(Builder builder) {
        this.leastAvailable = ApiTypeHelper.requireNonNull(builder.leastAvailable, this, "leastAvailable");
        this.mostAvailable = ApiTypeHelper.requireNonNull(builder.mostAvailable, this, "mostAvailable");
        this.nodeName = ApiTypeHelper.requireNonNull(builder.nodeName, this, "nodeName");
    }

    public static NodeDiskUsage of(Function<Builder, ObjectBuilder<NodeDiskUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final DiskUsage leastAvailable() {
        return this.leastAvailable;
    }

    @Nonnull
    public final DiskUsage mostAvailable() {
        return this.mostAvailable;
    }

    @Nonnull
    public final String nodeName() {
        return this.nodeName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("least_available");
        this.leastAvailable.serialize(generator, mapper);
        generator.writeKey("most_available");
        this.mostAvailable.serialize(generator, mapper);
        generator.writeKey("node_name");
        generator.write(this.nodeName);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeDiskUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::leastAvailable, DiskUsage._DESERIALIZER, "least_available");
        op.add(Builder::mostAvailable, DiskUsage._DESERIALIZER, "most_available");
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.leastAvailable.hashCode();
        result = 31 * result + this.mostAvailable.hashCode();
        result = 31 * result + this.nodeName.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeDiskUsage other = (NodeDiskUsage)o;
        return this.leastAvailable.equals(other.leastAvailable) && this.mostAvailable.equals(other.mostAvailable) && this.nodeName.equals(other.nodeName);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeDiskUsage> {
        private DiskUsage leastAvailable;
        private DiskUsage mostAvailable;
        private String nodeName;

        public Builder() {
        }

        private Builder(NodeDiskUsage o) {
            this.leastAvailable = o.leastAvailable;
            this.mostAvailable = o.mostAvailable;
            this.nodeName = o.nodeName;
        }

        private Builder(Builder o) {
            this.leastAvailable = o.leastAvailable;
            this.mostAvailable = o.mostAvailable;
            this.nodeName = o.nodeName;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder leastAvailable(DiskUsage value) {
            this.leastAvailable = value;
            return this;
        }

        @Nonnull
        public final Builder leastAvailable(Function<DiskUsage.Builder, ObjectBuilder<DiskUsage>> fn) {
            return this.leastAvailable(fn.apply(new DiskUsage.Builder()).build());
        }

        @Nonnull
        public final Builder mostAvailable(DiskUsage value) {
            this.mostAvailable = value;
            return this;
        }

        @Nonnull
        public final Builder mostAvailable(Function<DiskUsage.Builder, ObjectBuilder<DiskUsage>> fn) {
            return this.mostAvailable(fn.apply(new DiskUsage.Builder()).build());
        }

        @Nonnull
        public final Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeDiskUsage build() {
            this._checkSingleUse();
            return new NodeDiskUsage(this);
        }
    }
}

